/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainer;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ValueContainerEditorScreen
extends Screen {
    private final ValueContainer container;
    private final BlockPos pos;
    private final List<ValueContainerEntry<?>> entries;
    private final String formattedTitle;

    public ValueContainerEditorScreen(ValueContainer container, BlockPos pos) {
        this(container, pos, () -> new TranslationTextComponent("screen.sonar.value_container"));
    }

    @Deprecated
    public ValueContainerEditorScreen(ValueContainer container, BlockPos pos, Supplier<ITextComponent> defaultTitle) {
        super(container.getTitle((World)Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e), pos).orElseGet(defaultTitle));
        this.container = container;
        this.pos = pos;
        this.entries = container.getEntries((World)Minecraft.func_71410_x().field_71441_e, pos);
        this.formattedTitle = this.func_231171_q_().getString();
    }

    protected abstract void sendDataToServer();

    protected abstract void renderBackground(MatrixStack var1, int var2, int var3, float var4);

    protected abstract void renderForeground(MatrixStack var1, int var2, int var3, float var4);

    protected void tickChild(IGuiEventListener child) {
        if (child instanceof TextFieldWidget) {
            ((TextFieldWidget)child).func_146178_a();
        }
    }

    protected boolean shouldStayOpen() {
        return this.field_230706_i_ == null || this.field_230706_i_.field_71441_e == null || this.field_230706_i_.field_71441_e.func_180495_p(this.pos).func_177230_c() instanceof ValueContainer || this.field_230706_i_.field_71441_e.func_175625_s(this.pos) instanceof ValueContainer;
    }

    public void func_231023_e_() {
        if (this.field_230706_i_ == null || this.field_230706_i_.field_71439_g == null || this.field_230706_i_.field_71441_e == null) {
            return;
        }
        this.field_230705_e_.forEach(this::tickChild);
        if (!this.shouldStayOpen()) {
            this.field_230706_i_.field_71439_g.func_71053_j();
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_ == null) {
            return;
        }
        partialTicks = this.getMinecraft().func_184121_ak();
        super.func_230446_a_(matrixStack);
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.renderWidgets(matrixStack, mouseX, mouseY, partialTicks);
        this.renderForeground(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderWidgets(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (Widget button : this.field_230710_m_) {
            button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    public void func_231164_f_() {
        if (this.entries.stream().anyMatch(ValueContainerEntry::isDirty)) {
            this.sendDataToServer();
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.field_230706_i_ == null || this.field_230706_i_.field_71439_g == null) {
            return super.func_231046_a_(keyCode, scanCode, modifiers);
        }
        if (super.func_231046_a_(keyCode, scanCode, modifiers) || this.func_241217_q_() != null) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)keyCode, (int)scanCode);
        if (keyCode == 256 || this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (!this.func_212930_a(mouseX, mouseY).isPresent() || !super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            if (this.func_241217_q_() != null && !this.func_241217_q_().func_231047_b_(mouseX, mouseY)) {
                this.func_231035_a_(null);
                return true;
            }
            return false;
        }
        return true;
    }

    public ValueContainer getContainer() {
        return this.container;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public List<ValueContainerEntry<?>> getEntries() {
        return this.entries;
    }

    public String getFormattedTitle() {
        return this.formattedTitle;
    }
}

