/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.screen;

import io.github.ocelot.lib.sonar.common.valuecontainer.SliderEntry;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainerEntry;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ValueContainerEntrySliderImpl
extends AbstractSlider {
    private final DecimalFormat format;
    private final ValueContainerEntry<?> entry;
    private final SliderEntry sliderEntry;

    public ValueContainerEntrySliderImpl(ValueContainerEntry<?> entry, int x, int y, int width, int height) {
        super(x, y, width, height, entry.getDisplayName(), 0.0);
        if (!(entry instanceof SliderEntry)) {
            throw new IllegalStateException("Entry '" + entry + "' needs to implement SliderEntry in order to use the SLIDER type");
        }
        this.format = this.createDecimalFormat();
        this.entry = entry;
        this.sliderEntry = (SliderEntry)((Object)entry);
        this.field_230683_b_ = (this.sliderEntry.getSliderValue() - this.sliderEntry.getMinSliderValue()) / (this.sliderEntry.getMaxSliderValue() - this.sliderEntry.getMinSliderValue());
        this.func_230979_b_();
    }

    protected void func_230979_b_() {
        if (this.sliderEntry.isPercentage()) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.format.format(Math.floor(this.field_230683_b_ * 100.0)) + "%"));
        } else {
            double sliderValue = this.field_230683_b_ * (this.sliderEntry.getMaxSliderValue() - this.sliderEntry.getMinSliderValue()) + this.sliderEntry.getMinSliderValue();
            this.func_238482_a_((ITextComponent)new StringTextComponent(this.format.format(this.sliderEntry.isDecimal() ? sliderValue : Math.floor(sliderValue))));
        }
    }

    protected void func_230972_a_() {
        Optional<Predicate<String>> optional = this.entry.getValidator();
        double sliderValue = this.field_230683_b_ * (this.sliderEntry.getMaxSliderValue() - this.sliderEntry.getMinSliderValue()) + this.sliderEntry.getMinSliderValue();
        String value = String.valueOf(this.sliderEntry.isDecimal() ? sliderValue : Math.floor(sliderValue));
        if (optional.isPresent() && !optional.get().test(value)) {
            return;
        }
        this.entry.parse(value);
    }

    protected DecimalFormat createDecimalFormat() {
        DecimalFormat decimalformat = new DecimalFormat("#.#");
        decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        return decimalformat;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public ValueContainerEntry<?> getEntry() {
        return this.entry;
    }

    public SliderEntry getSliderEntry() {
        return this.sliderEntry;
    }
}

