/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.screen;

import io.github.ocelot.lib.sonar.common.valuecontainer.ToggleEntry;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ValueContainerEntryToggleImpl
extends AbstractButton {
    private final ValueContainerEntry<?> entry;
    private final ToggleEntry toggleEntry;
    private boolean toggled;

    public ValueContainerEntryToggleImpl(ValueContainerEntry<?> entry, int x, int y, int width, int height) {
        super(x, y, width, height, entry.getDisplayName());
        if (!(entry instanceof ToggleEntry)) {
            throw new IllegalStateException("Entry '" + entry + "' needs to implement ToggleEntry in order to use the TOGGLE type");
        }
        this.toggleEntry = (ToggleEntry)((Object)entry);
        this.entry = entry;
        this.setToggled(this.toggleEntry.isToggled());
    }

    public void func_230930_b_() {
        Optional<Predicate<String>> optional = this.entry.getValidator();
        String value = Boolean.toString(!this.toggled);
        if (optional.isPresent() && !optional.get().test(value)) {
            return;
        }
        this.setToggled(!this.toggled);
        this.entry.parse(value);
    }

    public ValueContainerEntry<?> getEntry() {
        return this.entry;
    }

    public ToggleEntry getToggleEntry() {
        return this.toggleEntry;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
        this.func_238482_a_((ITextComponent)(toggled ? new TranslationTextComponent("gui.yes") : new TranslationTextComponent("gui.no")));
    }
}

