/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.util;

import com.google.common.base.Charsets;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ocelot.lib.sonar.client.util.TextureCache;
import io.github.ocelot.lib.sonar.common.util.OnlineRequest;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class OnlineImageCache
implements TextureCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path cacheFolder;
    private final Path cacheFile;
    private final Map<String, ResourceLocation> locationCache;
    private final Set<String> errored;
    private final Map<String, CompletableFuture<ResourceLocation>> requested;
    private final Map<String, Long> textureCache;
    private final long textureCacheTime;
    private JsonObject cacheFileData;

    public OnlineImageCache() {
        this("sonar", -1L, TimeUnit.MILLISECONDS);
    }

    public OnlineImageCache(String domain) {
        this(domain, -1L, TimeUnit.MILLISECONDS);
    }

    public OnlineImageCache(long textureCacheTime, TimeUnit unit) {
        this("sonar", textureCacheTime, unit);
    }

    public OnlineImageCache(String domain, long textureCacheTime, TimeUnit unit) {
        this.cacheFolder = Minecraft.func_71410_x().field_71412_D.toPath().resolve(domain + "-online-image-cache");
        this.cacheFile = this.cacheFolder.resolve("cache.json");
        this.locationCache = new HashMap<String, ResourceLocation>();
        this.errored = new HashSet<String>();
        this.requested = new HashMap<String, CompletableFuture<ResourceLocation>>();
        this.textureCache = new HashMap<String, Long>();
        this.textureCacheTime = unit.toMillis(textureCacheTime);
        if (Files.exists(this.cacheFile, new LinkOption[0])) {
            try (InputStreamReader is = new InputStreamReader(new FileInputStream(this.cacheFile.toFile()));){
                this.cacheFileData = new JsonParser().parse((Reader)is).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache from '" + this.cacheFile + "'", (Throwable)e);
                this.cacheFileData = new JsonObject();
            }
        } else {
            this.cacheFileData = new JsonObject();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean hasTextureExpired(String hash) {
        return this.textureCacheTime > 0L && (!this.textureCache.containsKey(hash) || System.currentTimeMillis() - this.textureCache.get(hash) > 0L);
    }

    private boolean hasExpired(String hash) {
        return !this.cacheFileData.has(hash) || this.cacheFileData.get(hash).getAsLong() != -1L && System.currentTimeMillis() - this.cacheFileData.get(hash).getAsLong() > 0L;
    }

    @Nullable
    private synchronized CompletableFuture<ResourceLocation> loadCache(String hash, ResourceLocation location) {
        if (!Files.exists(this.cacheFolder, new LinkOption[0])) {
            return null;
        }
        Path imageFile = this.cacheFolder.resolve(hash);
        if (!Files.exists(imageFile, new LinkOption[0])) {
            return null;
        }
        if (this.hasExpired(hash)) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> {
            try (FileInputStream is = new FileInputStream(imageFile.toFile());){
                NativeImage nativeImage = NativeImage.func_195713_a((InputStream)is);
                return nativeImage;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load image with hash '" + hash + "' from cache. Deleting", (Throwable)e);
                return null;
            }
        }, Util.func_240992_g_()).thenApplyAsync(image -> {
            if (image == null) {
                try {
                    this.cacheFileData.remove(hash);
                    Files.delete(imageFile);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to delete image with hash '" + hash + "' from cache.", (Throwable)e);
                }
                this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
                this.errored.add(hash);
                return MissingTextureSprite.func_195675_b();
            }
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(location, (Texture)new DynamicTexture(image));
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return location;
        }, command -> RenderSystem.recordRenderCall(command::run));
    }

    private synchronized void writeCache(String hash, NativeImage image, long expirationDate) throws IOException {
        if (!Files.exists(this.cacheFolder, new LinkOption[0])) {
            Files.createDirectories(this.cacheFolder, new FileAttribute[0]);
        }
        if (!Files.exists(this.cacheFile, new LinkOption[0])) {
            Files.createFile(this.cacheFile, new FileAttribute[0]);
        }
        this.cacheFileData.addProperty(hash, (Number)expirationDate);
        try (FileOutputStream os = new FileOutputStream(this.cacheFile.toFile());){
            IOUtils.write((String)this.cacheFileData.toString(), (OutputStream)os, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache to file.", (Throwable)e);
        }
        image.func_209270_a(this.cacheFolder.resolve(hash));
    }

    @Override
    public CompletableFuture<ResourceLocation> requestTexture(String url) {
        String hash = DigestUtils.md5Hex((String)url);
        if (this.errored.contains(hash)) {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return CompletableFuture.completedFuture(MissingTextureSprite.func_195675_b());
        }
        ResourceLocation location = this.locationCache.computeIfAbsent(hash, key -> new ResourceLocation("sonar", key));
        if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(location) != null) {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            return CompletableFuture.completedFuture(location);
        }
        if (this.requested.containsKey(hash)) {
            return this.requested.get(hash);
        }
        CompletableFuture<ResourceLocation> cachedFuture = this.loadCache(hash, location);
        if (cachedFuture != null) {
            this.requested.put(hash, cachedFuture);
            return cachedFuture;
        }
        LOGGER.info("Requesting image from '" + hash + "'");
        CompletionStage future = ((CompletableFuture)OnlineRequest.request(url).thenApplyAsync(result -> {
            if (result == null) {
                return null;
            }
            try {
                NativeImage image = NativeImage.func_195713_a((InputStream)result);
                this.writeCache(hash, image, System.currentTimeMillis() + this.textureCacheTime);
                return image;
            }
            catch (IOException e) {
                LOGGER.error("Failed to load online texture from '" + url + "'. Using missing texture sprite.", (Throwable)e);
                return null;
            }
        })).thenApplyAsync(image -> {
            this.textureCache.put(hash, System.currentTimeMillis() + 30000L);
            if (image == null) {
                this.errored.add(hash);
                return MissingTextureSprite.func_195675_b();
            }
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(location, (Texture)new DynamicTexture(image));
            return location;
        }, command -> RenderSystem.recordRenderCall(command::run));
        this.requested.put(hash, (CompletableFuture<ResourceLocation>)future);
        return future;
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ClientTickEvent event) {
        this.locationCache.entrySet().removeIf(entry -> Minecraft.func_71410_x().func_110434_K().func_229267_b_((ResourceLocation)entry.getValue()) == null);
        this.locationCache.forEach((hash, location) -> {
            if (this.hasTextureExpired((String)hash)) {
                Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().func_110434_K().func_147645_c(location));
            }
        });
        this.errored.removeIf(this::hasTextureExpired);
        this.requested.values().removeIf(CompletableFuture::isDone);
    }
}

