/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.util;

import java.util.Stack;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.lwjgl.opengl.GL11C;

@OnlyIn(value=Dist.CLIENT)
public final class ScissorHelper {
    private static final Stack<Entry> stack = new Stack();
    private static boolean scissor = GL11C.glGetBoolean((int)3089);
    public static int framebufferHeight = 0;
    public static double framebufferScale = 0.0;

    private ScissorHelper() {
    }

    private static void applyScissor() {
        if (!stack.isEmpty()) {
            Entry entry = stack.peek();
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            double scale = framebufferScale == 0.0 ? window.func_198100_s() : framebufferScale;
            int frameHeight = framebufferHeight == 0 ? window.func_198091_l() : framebufferHeight;
            ScissorHelper.enableScissorInternal();
            GL11C.glScissor((int)((int)((double)entry.getX() * scale)), (int)((int)((double)frameHeight - (double)(entry.getY() + entry.getHeight()) * scale)), (int)((int)Math.max(0.0, (double)entry.getWidth() * scale)), (int)((int)Math.max(0.0, (double)entry.getHeight() * scale)));
        } else {
            ScissorHelper.disableScissorInternal();
        }
    }

    private static void enableScissorInternal() {
        if (!scissor) {
            GL11C.glEnable((int)3089);
            scissor = true;
        }
    }

    private static void disableScissorInternal() {
        if (scissor) {
            GL11C.glDisable((int)3089);
            scissor = false;
        }
    }

    public static void push(float x, float y, float width, float height) {
        Validate.isTrue((width >= 0.0f ? 1 : 0) != 0, (String)"Scissor width cannot be negative", (Object[])new Object[0]);
        Validate.isTrue((height >= 0.0f ? 1 : 0) != 0, (String)"Scissor height cannot be negative", (Object[])new Object[0]);
        if (!stack.isEmpty()) {
            Entry parent = stack.peek();
            if (x < parent.getX()) {
                width -= parent.getX() - x;
                x = parent.getX();
            }
            if (y < parent.getY()) {
                height -= parent.getY() - y;
                y = parent.getY();
            }
            if (x + width > parent.getX() + parent.getWidth()) {
                width = parent.getX() + parent.getWidth() - x;
            }
            if (y + height > parent.getY() + parent.getHeight()) {
                height = parent.getY() + parent.getHeight() - y;
            }
        }
        stack.push(new Entry(x, y, width, height));
        ScissorHelper.applyScissor();
    }

    public static void pop() {
        if (!stack.isEmpty()) {
            stack.pop();
        }
        ScissorHelper.applyScissor();
    }

    public static void clear() {
        ScissorHelper.disableScissorInternal();
        stack.clear();
    }

    public static Entry getTop() {
        return stack.peek();
    }

    public static boolean isEmpty() {
        return stack.isEmpty();
    }

    public static class Entry {
        private final float x;
        private final float y;
        private final float width;
        private final float height;

        private Entry(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }
    }
}

