/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinHelper {
    private static final Map<GameProfile, GameProfile> PROFILE_CACHE = new WeakHashMap<GameProfile, GameProfile>();

    @Nullable
    public static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (input == null) {
            return null;
        }
        return PROFILE_CACHE.computeIfAbsent(input, SkullTileEntity::func_174884_b);
    }

    public static void loadPlayerTexture(@Nullable GameProfile input, MinecraftProfileTexture.Type type, Consumer<ResourceLocation> consumer) {
        CompletableFuture.runAsync(() -> {
            if (input == null) {
                consumer.accept(DefaultPlayerSkin.func_177335_a());
                return;
            }
            Map map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(input);
            if (map.containsKey(type)) {
                RenderSystem.recordRenderCall(() -> consumer.accept(Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(type), type)));
            } else {
                consumer.accept(DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)input)));
            }
        }, Util.func_215072_e());
    }
}

