/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.util;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.io.IOUtils;

public final class SonarDevelopmentPack
extends ResourcePack {
    private static final Gson GSON = new Gson();
    private String[] resources;

    private SonarDevelopmentPack() {
        super(new File("Sonar Resources"));
    }

    public static void init() {
        if (FMLLoader.isProduction() || Minecraft.func_71410_x() == null) {
            return;
        }
        Minecraft.func_71410_x().func_195548_H().addPackFinder((packs, packInfoFactory) -> {
            ResourcePackInfo t1 = ResourcePackInfo.func_195793_a((String)"sonar_dev", (boolean)true, SonarDevelopmentPack::new, (ResourcePackInfo.IFactory)packInfoFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_);
            if (t1 != null) {
                packs.accept(t1);
            }
        });
    }

    private String[] getResources() throws IOException {
        if (this.resources == null) {
            this.resources = (String[])JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)SonarDevelopmentPack.class.getResourceAsStream("/sonar_resources.json"), (Charset)StandardCharsets.UTF_8), String[].class);
            if (this.resources == null) {
                this.resources = new String[0];
            }
        }
        return this.resources;
    }

    protected InputStream func_195766_a(String resourcePath) {
        return SonarDevelopmentPack.class.getResourceAsStream("/" + resourcePath);
    }

    public boolean func_195768_c(String resourcePath) {
        try {
            return Arrays.asList(this.getResources()).contains(resourcePath);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public Set<String> func_195759_a(ResourcePackType type) {
        return Collections.singleton("sonar");
    }

    public void close() {
    }

    public Collection<ResourceLocation> func_225637_a_(ResourcePackType type, String namespaceIn, String pathIn, int maxDepthIn, Predicate<String> filterIn) {
        try {
            return Arrays.stream(this.getResources()).filter(resource -> namespaceIn.equals("sonar") && resource.startsWith(pathIn) && filterIn.test((String)resource)).map(resource -> new ResourceLocation("sonar", resource.substring(8 + "sonar".length()))).collect(Collectors.toSet());
        }
        catch (IOException e) {
            return Collections.emptySet();
        }
    }

    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> deserializer) throws IOException {
        Object object;
        try (InputStream inputstream = this.func_195766_a("sonar_pack.mcmeta");){
            object = SonarDevelopmentPack.func_195770_a(deserializer, (InputStream)inputstream);
        }
        return (T)object;
    }

    public boolean isHidden() {
        return true;
    }
}

