/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ocelot.lib.sonar.common.util.OnlineRequest;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public interface TextureCache {
    public static final TextureCache NONE = url -> {
        Logger logger = LogManager.getLogger();
        logger.info("Requesting image from '" + url + "'");
        return OnlineRequest.request(url, Util.func_215072_e()).thenApplyAsync(stream -> {
            try {
                NativeImage image = NativeImage.func_195713_a((InputStream)stream);
                ResourceLocation location = new ResourceLocation(DigestUtils.md5Hex((String)url));
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(location, (Texture)new DynamicTexture(image));
                return location;
            }
            catch (Exception e) {
                logger.error("Failed to load image from '" + url + "'", (Throwable)e);
                return MissingTextureSprite.func_195675_b();
            }
        }, task -> RenderSystem.recordRenderCall(task::run));
    };

    @Nullable
    default public ResourceLocation getTextureLocation(String url) {
        return this.requestTexture(url).getNow(null);
    }

    public CompletableFuture<ResourceLocation> requestTexture(String var1);
}

