/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BaseBlock
extends Block {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BaseBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return BaseBlock.getComparatorInputOverride(world.func_175625_s(pos));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (state.func_235901_b_((Property)WATERLOGGED) && ((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        if (state.func_235901_b_((Property)HORIZONTAL_FACING)) {
            state = (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d());
        }
        if (state.func_235901_b_((Property)FACING)) {
            state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
        }
        if (state.func_235901_b_((Property)WATERLOGGED)) {
            state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return state;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (state.func_235901_b_((Property)HORIZONTAL_FACING)) {
            state = (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
        }
        if (state.func_235901_b_((Property)FACING)) {
            state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        if (state.func_235901_b_((Property)HORIZONTAL_FACING)) {
            state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
        }
        if (state.func_235901_b_((Property)FACING)) {
            state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
        }
        return state;
    }

    public FluidState func_204507_t(BlockState state) {
        return state.func_235901_b_((Property)WATERLOGGED) && (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ITextComponent> getTitle(World world, BlockPos pos) {
        return Optional.of(this.func_235333_g_());
    }

    public static int getComparatorInputOverride(@Nullable TileEntity te) {
        if (te == null) {
            return 0;
        }
        LazyOptional itemCapability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (itemCapability.isPresent()) {
            IItemHandler inventory = (IItemHandler)itemCapability.orElseThrow(() -> new NullPointerException("Inventory Capability was null when present!"));
            boolean empty = true;
            float fillPercentage = 0.0f;
            for (int j = 0; j < inventory.getSlots(); ++j) {
                ItemStack itemstack = inventory.getStackInSlot(j);
                if (itemstack.func_190926_b()) continue;
                fillPercentage += (float)itemstack.func_190916_E() / (float)Math.min(inventory.getSlotLimit(j), itemstack.func_77976_d());
                empty = false;
            }
            return MathHelper.func_76141_d((float)(fillPercentage / (float)inventory.getSlots() * 14.0f)) + (!empty ? 1 : 0);
        }
        return te instanceof IInventory ? Container.func_94526_b((IInventory)((IInventory)te)) : 0;
    }
}

