/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.item;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class SpawnEggItemBase<T extends EntityType<?>>
extends SpawnEggItem {
    private static final Map<EntityType<?>, SpawnEggItem> SPAWN_EGGS = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
    private final boolean addToMisc;
    private final Supplier<T> type;

    public SpawnEggItemBase(Supplier<T> type, int backgroundColor, int spotColor, boolean addToMisc, Item.Properties builder) {
        super(null, backgroundColor, spotColor, builder);
        this.type = type;
        this.addToMisc = addToMisc;
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, EventPriority.LOWEST, this::onEvent);
    }

    private void onEvent(RegistryEvent.Register<EntityType<?>> event) {
        if (SPAWN_EGGS == null) {
            throw new RuntimeException("Failed to inject spawns eggs");
        }
        SPAWN_EGGS.put((EntityType<?>)this.type.get(), this);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) || this.addToMisc && group == ItemGroup.field_78026_f) {
            if (items.stream().anyMatch(stack -> stack.func_77973_b() instanceof SpawnEggItem)) {
                Optional optional;
                String itemName = this.getRegistryName() == null ? null : this.getRegistryName().func_110623_a();
                Optional<Object> optional2 = optional = itemName == null ? Optional.empty() : items.stream().filter(stack -> stack.func_77973_b() instanceof SpawnEggItem).max((a, b) -> {
                    if (a.func_77973_b().getRegistryName() == null || b.func_77973_b().getRegistryName() == null) {
                        return 0;
                    }
                    int valA = itemName.compareToIgnoreCase(a.func_77973_b().getRegistryName().func_110623_a());
                    int valB = b.func_77973_b().getRegistryName().func_110623_a().compareToIgnoreCase(itemName);
                    return valB - valA;
                });
                if (optional.isPresent()) {
                    items.add(items.indexOf(optional.get()) + 1, (Object)new ItemStack((IItemProvider)this));
                    return;
                }
            }
            items.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT p_208076_1_) {
        CompoundNBT compoundnbt;
        if (p_208076_1_ != null && p_208076_1_.func_150297_b("EntityTag", 10) && (compoundnbt = p_208076_1_.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return (EntityType)EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElseGet(this.type);
        }
        return (EntityType)this.type.get();
    }
}

