/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.item;

import io.github.ocelot.lib.sonar.Sonar;
import io.github.ocelot.lib.sonar.SonarModule;
import io.github.ocelot.lib.sonar.common.network.inbuilt.SonarInbuiltMessages;
import io.github.ocelot.lib.sonar.common.valuecontainer.OpenValueContainerMessage;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainer;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class ValueContainerEditorItem
extends Item {
    public ValueContainerEditorItem(Item.Properties properties) {
        super(properties);
    }

    protected boolean canPlayerUse(ValueContainer valueContainer, World world, BlockPos pos, PlayerEntity player) {
        return player.func_195070_dx();
    }

    protected boolean sendPacket(ValueContainer valueContainer, ServerWorld world, BlockPos pos, ServerPlayerEntity player) {
        if (!Sonar.isModuleLoaded(SonarModule.INBUILT_NETWORK)) {
            throw new IllegalStateException("There is no implementation to send a packet! Enable INBUILT_NETWORK Sonar Module to automatically handle.");
        }
        SonarInbuiltMessages.PLAY.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OpenValueContainerMessage((World)world, pos));
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Optional<ValueContainer> valueContainerOptional;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (player != null && player.func_184812_l_() && (valueContainerOptional = ValueContainer.get((IBlockReader)world, pos)).isPresent()) {
            ValueContainer valueContainer = valueContainerOptional.get();
            if (!world.func_201670_d()) {
                if (!this.canPlayerUse(valueContainer, world, pos, player)) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(this.func_77667_c(context.func_195996_i()) + ".cannot_edit"), false);
                    return ActionResultType.SUCCESS;
                }
                if (this.sendPacket(valueContainer, (ServerWorld)world, pos, (ServerPlayerEntity)player)) {
                    return ActionResultType.SUCCESS;
                }
            } else if (this.canPlayerUse(valueContainer, world, pos, player)) {
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }
}

