/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.network;

import io.github.ocelot.lib.sonar.common.network.message.SonarLoginMessage;
import io.github.ocelot.lib.sonar.common.network.message.SonarMessage;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.network.login.IClientLoginNetHandler;
import net.minecraft.client.network.status.IClientStatusNetHandler;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.status.IServerStatusNetHandler;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SonarNetworkManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimpleChannel channel;
    private final LazyValue<LazyValue<Object>> clientMessageHandler;
    private final LazyValue<LazyValue<Object>> serverMessageHandler;
    private int nextId;

    public SonarNetworkManager(SimpleChannel channel, Supplier<Supplier<Object>> clientFactory, Supplier<Supplier<Object>> serverFactory) {
        this.channel = channel;
        this.clientMessageHandler = new LazyValue(() -> new LazyValue((Supplier)clientFactory.get()));
        this.serverMessageHandler = new LazyValue(() -> new LazyValue((Supplier)serverFactory.get()));
    }

    private <MSG extends SonarMessage<T>, T> boolean processMessage(MSG msg, Supplier<NetworkEvent.Context> ctx) {
        block6: {
            try {
                msg.processPacket((Object)(ctx.get().getDirection().getReceptionSide().isClient() ? ((LazyValue)this.clientMessageHandler.func_179281_c()).func_179281_c() : ((LazyValue)this.serverMessageHandler.func_179281_c()).func_179281_c()), ctx.get());
            }
            catch (Exception e) {
                LOGGER.error("Failed to process packet for class: " + msg.getClass().getName(), (Throwable)e);
                TranslationTextComponent reason = new TranslationTextComponent("disconnect.genericReason", new Object[]{"Internal Exception: " + e});
                NetworkManager networkManager = ctx.get().getNetworkManager();
                INetHandler netHandler = networkManager.func_150729_e();
                boolean local = networkManager.func_150731_c();
                if (netHandler instanceof IServerStatusNetHandler) {
                    networkManager.func_150718_a((ITextComponent)reason);
                }
                if (netHandler instanceof ServerLoginNetHandler) {
                    ((ServerLoginNetHandler)netHandler).func_194026_b((ITextComponent)reason);
                }
                if (netHandler instanceof ServerPlayNetHandler) {
                    ((ServerPlayNetHandler)netHandler).func_194028_b((ITextComponent)reason);
                }
                if (netHandler instanceof IClientStatusNetHandler) {
                    networkManager.func_150718_a((ITextComponent)reason);
                    netHandler.func_147231_a((ITextComponent)reason);
                }
                if (!(netHandler instanceof IClientLoginNetHandler)) break block6;
                networkManager.func_150718_a((ITextComponent)reason);
                netHandler.func_147231_a((ITextComponent)reason);
            }
        }
        return true;
    }

    private <MSG extends SonarMessage<T>, T> SimpleChannel.MessageBuilder<MSG> getMessageBuilder(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        return this.channel.messageBuilder(clazz, this.nextId++, direction).encoder(SonarMessage::writePacketData).decoder(buf -> {
            SonarMessage msg = (SonarMessage)generator.get();
            msg.readPacketData((PacketBuffer)buf);
            return msg;
        }).consumer(this::processMessage);
    }

    public <MSG extends SonarMessage<T>, T> void register(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLoginReply(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.channel.messageBuilder(clazz, this.nextId++, direction).encoder(SonarMessage::writePacketData).decoder(buf -> {
            SonarLoginMessage msg = (SonarLoginMessage)generator.get();
            msg.readPacketData((PacketBuffer)buf);
            return msg;
        }).consumer(FMLHandshakeHandler.indexFirst((__, msg, ctx) -> ((NetworkEvent.Context)ctx.get()).setPacketHandled(this.processMessage((SonarMessage)msg, (Supplier<NetworkEvent.Context>)ctx)))).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLogin(Class<MSG> clazz, Supplier<MSG> generator, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).markAsLoginPacket().add();
    }

    public <MSG extends SonarLoginMessage<T>, T> void registerLogin(Class<MSG> clazz, Supplier<MSG> generator, Function<Boolean, List<Pair<String, MSG>>> loginPacketGenerators, @Nullable NetworkDirection direction) {
        this.getMessageBuilder(clazz, generator, direction).loginIndex(SonarLoginMessage::getAsInt, SonarLoginMessage::setLoginIndex).buildLoginPacketList(loginPacketGenerators).add();
    }
}

