/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnlineRequest {
    private static final Logger LOGGER = LogManager.getLogger();
    private static String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";

    public static InputStream get(String url) throws URISyntaxException, IOException {
        HttpURLConnection connection = (HttpURLConnection)new URI(url).toURL().openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        InputStream stream = connection.getInputStream();
        if (connection.getResponseCode() != 200) {
            if (stream != null) {
                stream.close();
            }
            if (connection.getErrorStream() != null) {
                connection.getErrorStream().close();
            }
            throw new IOException("Failed to connect to '" + url + "'. " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return stream;
    }

    public static CompletableFuture<InputStream> request(String url, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream stream = OnlineRequest.get(url);){
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                return inputStream;
            }
            catch (Exception e) {
                LOGGER.error("Failed to fully read stream from '" + url + "'", (Throwable)e);
                return null;
            }
        }, executor);
    }

    public static CompletableFuture<InputStream> request(String url) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStream stream = OnlineRequest.get(url);){
                InputStream inputStream = IOUtils.toBufferedInputStream((InputStream)stream);
                return inputStream;
            }
            catch (Exception e) {
                LOGGER.error("Failed to fully read stream from '" + url + "'", (Throwable)e);
                return null;
            }
        });
    }

    public static void setUserAgent(String userAgent) {
        USER_AGENT = userAgent;
    }
}

