/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.valuecontainer;

import io.github.ocelot.lib.sonar.common.valuecontainer.NumberValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public class LongValueContainerEntry
extends NumberValueContainerEntry<Long> {
    private final ITextComponent displayName;
    private boolean bounds;

    public LongValueContainerEntry(ITextComponent displayName, String name, long value) {
        this(displayName, name, value, Long.MIN_VALUE, Long.MAX_VALUE);
        this.bounds = false;
    }

    public LongValueContainerEntry(ITextComponent displayName, String name, long value, long minValue, long maxValue) {
        super(name, value, minValue, maxValue);
        this.displayName = displayName;
        this.bounds = true;
    }

    @Override
    protected Long getValue(Number number) {
        return number.longValue();
    }

    @Override
    protected Long clamp(Long value, Long minValue, Long maxValue) {
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected boolean hasBounds() {
        return this.bounds;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74772_a(this.getName(), ((Long)this.value).longValue());
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.value = nbt.func_150297_b(this.getName(), 4) ? Long.valueOf(nbt.func_74763_f(this.getName())) : (Long)this.getPreviousValue();
    }

    @Override
    public boolean isDecimal() {
        return false;
    }
}

