/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.valuecontainer;

import io.github.ocelot.lib.sonar.common.network.message.SonarMessage;
import io.github.ocelot.lib.sonar.common.valuecontainer.IValueContainerClientHandler;
import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class OpenValueContainerMessage
implements SonarMessage<IValueContainerClientHandler> {
    private BlockPos pos;
    private CompoundNBT nbt;

    public OpenValueContainerMessage() {
    }

    public OpenValueContainerMessage(World world, BlockPos pos) {
        this.pos = pos;
        this.nbt = ValueContainer.get((IBlockReader)world, pos).map(container -> container.writeClientValueContainer(world, pos)).orElse(null);
    }

    @Override
    public void readPacketData(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.nbt = buf.readBoolean() ? buf.func_150793_b() : null;
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.nbt != null);
        if (this.nbt != null) {
            buf.func_150786_a(this.nbt);
        }
    }

    @Override
    public void processPacket(IValueContainerClientHandler handler, NetworkEvent.Context ctx) {
        handler.handleOpenValueContainerMessage(this, ctx);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getPos() {
        return this.pos;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public CompoundNBT getNbt() {
        return this.nbt;
    }
}

