/*
 * Decompiled with CFR 0.152.
 */
package io.github.ocelot.lib.sonar.common.valuecontainer;

import io.github.ocelot.lib.sonar.common.valuecontainer.ValueContainerEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public interface ValueContainer {
    public void getEntries(World var1, BlockPos var2, List<ValueContainerEntry<?>> var3);

    public void readEntries(World var1, BlockPos var2, Map<String, ValueContainerEntry<?>> var3);

    @Nullable
    default public CompoundNBT writeClientValueContainer(World world, BlockPos pos) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void readClientValueContainer(World world, BlockPos pos, CompoundNBT nbt) {
    }

    default public List<ValueContainerEntry<?>> getEntries(World world, BlockPos pos) {
        ArrayList entries = new ArrayList();
        this.getEntries(world, pos, entries);
        return entries;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ITextComponent> getTitle(World var1, BlockPos var2);

    public static CompoundNBT serialize(List<ValueContainerEntry<?>> entries) {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT entriesNbt = new ListNBT();
        entries.forEach(valueContainerEntry -> {
            if (!valueContainerEntry.isDirty()) {
                return;
            }
            try {
                CompoundNBT valueContainerEntryNbt = new CompoundNBT();
                valueContainerEntryNbt.func_74778_a("name", valueContainerEntry.getName());
                CompoundNBT entryDataNbt = new CompoundNBT();
                valueContainerEntry.write(entryDataNbt);
                valueContainerEntryNbt.func_218657_a("data", (INBT)entryDataNbt);
                entriesNbt.add((Object)valueContainerEntryNbt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        nbt.func_218657_a("entries", (INBT)entriesNbt);
        return nbt;
    }

    public static void deserialize(World world, BlockPos pos, ValueContainer container, CompoundNBT nbt) {
        HashMap entries = new HashMap();
        container.getEntries(world, pos).forEach(valueContainerEntry -> entries.put(valueContainerEntry.getName(), valueContainerEntry));
        HashMap deserializedEntries = new HashMap();
        ListNBT entriesNbt = nbt.func_150295_c("entries", 10);
        for (int i = 0; i < entriesNbt.size(); ++i) {
            CompoundNBT valueContainerEntryNbt = entriesNbt.func_150305_b(i);
            String name = valueContainerEntryNbt.func_74779_i("name");
            try {
                if (!entries.containsKey(name)) {
                    throw new IllegalStateException("Expected to deserialize '" + name + "', but it is not a valid property!");
                }
                ValueContainerEntry valueContainerEntry2 = (ValueContainerEntry)entries.get(name);
                valueContainerEntry2.read(valueContainerEntryNbt.func_74775_l("data"));
                deserializedEntries.put(valueContainerEntry2.getName(), valueContainerEntry2);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!deserializedEntries.isEmpty()) {
            container.readEntries(world, pos, deserializedEntries);
        }
    }

    public static Optional<ValueContainer> get(IBlockReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof ValueContainer) {
            return Optional.ofNullable((ValueContainer)world.func_175625_s(pos));
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof ValueContainer) {
            return Optional.of((ValueContainer)world.func_180495_p(pos).func_177230_c());
        }
        return Optional.empty();
    }
}

