/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.healthcare.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2196;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import org.samo_lego.healthcare.HealthCare;
import org.samo_lego.healthcare.healthbar.HealthbarPreferences;
import org.samo_lego.healthcare.permission.PermissionHelper;

public class HealthbarCommand {
    private static final SuggestionProvider<class_2168> HEALTHBAR_STYLES = class_2321.method_10022((class_2960)new class_2960("healthcare", "healthbar_styles"), (context, builder) -> class_2172.method_9265((Iterable)Stream.of(HealthbarPreferences.HealthbarStyle.values()).map(Enum::name).collect(Collectors.toList()), (SuggestionsBuilder)builder));

    public static void register(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"healthbar").then(class_2170.method_9247((String)"toggle").executes(HealthbarCommand::toggleHealthBar))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").then(class_2170.method_9247((String)"style").then(class_2170.method_9244((String)"style", (ArgumentType)StringArgumentType.word()).suggests(HEALTHBAR_STYLES).executes(HealthbarCommand::editHealthbarStyle)))).then(class_2170.method_9247((String)"alwaysVisible").then(class_2170.method_9244((String)"visibility", (ArgumentType)BoolArgumentType.bool()).executes(HealthbarCommand::changeVisibility)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"custom").then(class_2170.method_9247((String)"healthbarLength").then(class_2170.method_9244((String)"length", (ArgumentType)IntegerArgumentType.integer((int)1, (int)HealthCare.config.maxHealthbarLength)).executes(HealthbarCommand::editHealthbarLength)))).then(class_2170.method_9247((String)"fullSymbol").then(class_2170.method_9244((String)"symbol", (ArgumentType)class_2196.method_9340()).executes(ctx -> HealthbarCommand.setSymbol((CommandContext<class_2168>)ctx, true))))).then(class_2170.method_9247((String)"emptySymbol").then(class_2170.method_9244((String)"symbol", (ArgumentType)class_2196.method_9340()).executes(ctx -> HealthbarCommand.setSymbol((CommandContext<class_2168>)ctx, false)))))));
    }

    private static int editHealthbarLength(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (HealthCare.LUCKPERMS_LOADED && !PermissionHelper.checkPermission((class_2168)context.getSource(), HealthCare.config.perms.healthbar_edit_custom_length, 0)) {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2585(HealthCare.config.lang.noPermission).method_27692(class_124.field_1061));
            return -1;
        }
        HealthbarPreferences preferences = (HealthbarPreferences)((class_2168)context.getSource()).method_9207();
        int length = IntegerArgumentType.getInteger(context, (String)"length");
        preferences.setCustomLength(length);
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(String.format(HealthCare.config.lang.customLengthSet, length)).method_27692(class_124.field_1060).method_27693("\n").method_10852((class_2561)new class_2585(HealthCare.config.lang.reloadRequired).method_27692(class_124.field_1065)), false);
        if (!preferences.getHealthbarStyle().equals((Object)HealthbarPreferences.HealthbarStyle.CUSTOM)) {
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(HealthCare.config.lang.useCustomStyle).method_27692(class_124.field_1065), false);
        }
        return 0;
    }

    private static int setSymbol(CommandContext<class_2168> context, boolean full) throws CommandSyntaxException {
        if (HealthCare.LUCKPERMS_LOADED && !PermissionHelper.checkPermission((class_2168)context.getSource(), full ? HealthCare.config.perms.healthbar_edit_custom_symbols_full : HealthCare.config.perms.healthbar_edit_custom_symbols_empty, 0)) {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2585(HealthCare.config.lang.noPermission).method_27692(class_124.field_1061));
            return -1;
        }
        HealthbarPreferences preferences = (HealthbarPreferences)((class_2168)context.getSource()).method_9207();
        char symbol = class_2196.method_9339(context, (String)"symbol").getString().toCharArray()[0];
        if (full) {
            preferences.setCustomFullChar(symbol);
        } else {
            preferences.setCustomEmptyChar(symbol);
        }
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(String.format(HealthCare.config.lang.customSymbolSet, full ? "Full" : "Empty", Character.valueOf(symbol))).method_27692(class_124.field_1060).method_27693("\n").method_10852((class_2561)new class_2585(HealthCare.config.lang.reloadRequired).method_27692(class_124.field_1065)), false);
        if (!preferences.getHealthbarStyle().equals((Object)HealthbarPreferences.HealthbarStyle.CUSTOM)) {
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(HealthCare.config.lang.useCustomStyle).method_27692(class_124.field_1065), false);
        }
        return 0;
    }

    private static int changeVisibility(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (HealthCare.LUCKPERMS_LOADED && !PermissionHelper.checkPermission((class_2168)context.getSource(), HealthCare.config.perms.healthbar_edit_visibility, 0)) {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2585(HealthCare.config.lang.noPermission).method_27692(class_124.field_1061));
            return -1;
        }
        HealthbarPreferences preferences = (HealthbarPreferences)((class_2168)context.getSource()).method_9207();
        boolean alwaysVisible = BoolArgumentType.getBool(context, (String)"visibility");
        preferences.setAlwaysVisible(alwaysVisible);
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(String.format(HealthCare.config.lang.visibilitySet, alwaysVisible)).method_27692(class_124.field_1060).method_27693("\n").method_10852((class_2561)new class_2585(HealthCare.config.lang.reloadRequired).method_27692(class_124.field_1065)), false);
        return 0;
    }

    private static int editHealthbarStyle(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (HealthCare.LUCKPERMS_LOADED && !PermissionHelper.checkPermission((class_2168)context.getSource(), HealthCare.config.perms.healthbar_edit_style, 0)) {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2585(HealthCare.config.lang.noPermission).method_27692(class_124.field_1061));
            return -1;
        }
        HealthbarPreferences preferences = (HealthbarPreferences)((class_2168)context.getSource()).method_9207();
        HealthbarPreferences.HealthbarStyle style = HealthbarPreferences.HealthbarStyle.valueOf(StringArgumentType.getString(context, (String)"style"));
        preferences.setHealthbarStyle(style);
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(String.format(HealthCare.config.lang.styleSet, style.toString())).method_27692(class_124.field_1060).method_27693("\n").method_10852((class_2561)new class_2585(HealthCare.config.lang.reloadRequired).method_27692(class_124.field_1065)), false);
        return 0;
    }

    private static int toggleHealthBar(CommandContext<class_2168> context) throws CommandSyntaxException {
        HealthbarPreferences preferences;
        if (HealthCare.LUCKPERMS_LOADED && !PermissionHelper.checkPermission((class_2168)context.getSource(), HealthCare.config.perms.healthbar_toggle, 0)) {
            ((class_2168)context.getSource()).method_9213((class_2561)new class_2585(HealthCare.config.lang.noPermission).method_27692(class_124.field_1061));
            return -1;
        }
        preferences.setEnabled(!(preferences = (HealthbarPreferences)((class_2168)context.getSource()).method_9207()).isEnabled());
        ((class_2168)context.getSource()).method_9226((class_2561)new class_2585(preferences.isEnabled() ? HealthCare.config.lang.healthbarEnabled : HealthCare.config.lang.healthbarDisabled).method_27692(class_124.field_1060).method_27693("\n").method_10852((class_2561)new class_2585(HealthCare.config.lang.reloadRequired).method_27692(class_124.field_1065)), false);
        return 0;
    }
}

