/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.healthcare.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;

public class HealthConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    public final String _comment_blacklistedEntities = "// Which entities shouldn't have a healthbar above their name.";
    @SerializedName(value="blacklisted_entities")
    public ArrayList<String> blacklistedEntities = new ArrayList<String>(Arrays.asList("taterzens:npc", "specialmobs:mob_with_hidden_health"));
    public String _comment_activationRange = "// When to activate the healthbar.";
    public float activationRange = 8.0f;
    public final Permissions perms = new Permissions();
    public final String _comment_maxHealthbarLength = "// Max length of healthbar a player can use.";
    public int maxHealthbarLength = 20;
    public Language lang = new Language();

    public static HealthConfig loadConfigFile(File file) {
        HealthConfig config;
        block8: {
            if (file.exists()) {
                try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                    config = (HealthConfig)gson.fromJson((Reader)fileReader, HealthConfig.class);
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("healthcare Problem occurred when trying to load config: ", e);
                }
            }
            config = new HealthConfig();
        }
        config.saveConfigFile(file);
        return config;
    }

    public void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            LogManager.getLogger((String)"healthcare").error("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public static class Language {
        public String noPermission = "You don't have permission to run this command.";
        public String configReloaded = "Config was reloaded successfully.";
        public String customLengthSet = "Length of healthbar was set to %s.";
        public String customSymbolSet = "%s healthbar symbol was set to %s.";
        public String visibilitySet = "Always-visible property of healthbar was set to: %s";
        public String styleSet = "Style of your healthbar has been set to %s.";
        public String useCustomStyle = "Make sure to use style CUSTOM to have your settings applied.";
        public String healthbarEnabled = "Healthbars are now enabled.";
        public String healthbarDisabled = "Healthbars are now disabled.";
        public String reloadRequired = "Changes will be visible after relogging or entity update.";
    }

    public static final class Permissions {
        public final String _comment = "// Enabled only if LuckPerms is loaded.";
        public final String healthcare_reloadConfig = "healthcare.reloadConfig";
        public final String _comment_playerPermissions = "// Player permissions";
        public final String healthbar_toggle = "healthcare.healthbar.toggle";
        public final String healthbar_edit_style = "healthcare.healthbar.edit.style";
        public final String healthbar_edit_visibility = "healthcare.healthbar.edit.visibility";
        public final String healthbar_edit_custom_length = "healthcare.healthbar.edit.custom.length";
        public final String healthbar_edit_custom_symbols_full = "healthcare.healthbar.edit.symbol.full";
        public final String healthbar_edit_custom_symbols_empty = "healthcare.healthbar.edit.symbol.empty";
    }
}

