/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages;

import com.google.common.collect.ImmutableList;
import com.hostilevillages.RandomVillageDataSet;
import com.hostilevillages.command.CommandFindPersistent;
import com.hostilevillages.config.Configuration;
import com.hostilevillages.event.EventHandler;
import com.hostilevillages.event.ModEventHandler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hostilevillages")
public class HostileVillages {
    public static final String MODID = "hostilevillages";
    public static final Random rand = new Random();
    public static final Logger LOGGER = LogManager.getLogger();
    public static Configuration config = new Configuration();
    private static Map<ResourceLocation, JigsawPattern> patterns = new HashMap<ResourceLocation, JigsawPattern>();

    public HostileVillages() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(ModEventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(EventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::serverStart);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::onCommandsRegister);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        RandomVillageDataSet.parseFromConfig();
        LOGGER.info("Hostile Villages initialized");
    }

    public void onCommandsRegister(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)MODID);
        event.getDispatcher().register((LiteralArgumentBuilder)root.then(new CommandFindPersistent().build()));
    }

    private void serverStart(FMLServerAboutToStartEvent event) {
        for (String name : Arrays.asList("plains", "savanna", "snowy", "taiga", "desert")) {
            List list = ((JigsawPattern)((MutableRegistry)event.getServer().func_244267_aX().func_230521_a_((RegistryKey)Registry.field_243555_ax).get()).func_82594_a((ResourceLocation)new ResourceLocation((String)new StringBuilder().append((String)"minecraft:village/").append((String)name).append((String)"/zombie/houses").toString()))).field_214953_e;
            for (String structure : (List)HostileVillages.config.getCommonConfig().additionalStructures.get()) {
                for (int i = 0; i < (Integer)HostileVillages.config.getCommonConfig().additionalStructuresWeight.get(); ++i) {
                    list.add(JigsawPiece.func_242849_a((String)structure).apply(JigsawPattern.PlacementBehaviour.RIGID));
                }
            }
        }
    }

    public static JigsawPattern getReplacement(JigsawPattern pattern) {
        if (patterns.containsKey(pattern.func_214947_b())) {
            return patterns.get(pattern.func_214947_b());
        }
        return null;
    }

    public static ImmutableList<com.mojang.datafixers.util.Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> newListOf(com.mojang.datafixers.util.Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer> ... args) {
        ArrayList<com.mojang.datafixers.util.Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> list = new ArrayList<com.mojang.datafixers.util.Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>>(Arrays.asList(args));
        list.removeIf(element -> (Integer)element.getSecond() <= 0);
        return ImmutableList.copyOf(list);
    }

    public static <T> Codec<ITag<T>> tagCodec(Supplier<ITagCollection<T>> iTagCollection) {
        return ResourceLocation.field_240908_a_.flatXmap(p_232949_1_ -> Optional.ofNullable(((ITagCollection)iTagCollection.get()).func_199910_a(p_232949_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232949_1_))), tag -> {
            ResourceLocation id = ((ITagCollection)iTagCollection.get()).func_232973_a_(tag);
            if (id == null) {
                Collection tags = ((ITagCollection)iTagCollection.get()).func_199913_a(tag.func_230236_b_().get(0));
                for (ResourceLocation currentID : tags) {
                    ITag compare = ((ITagCollection)iTagCollection.get()).func_199910_a(currentID);
                    if (compare == null || !compare.func_230236_b_().equals(tag.func_230236_b_())) continue;
                    id = currentID;
                    break;
                }
            }
            return Optional.ofNullable(id).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + tag)));
        });
    }

    static {
        int villageChance = (Integer)HostileVillages.config.getCommonConfig().vanillaVillageChance.get();
        int zombieChance = 100 - villageChance;
        int villageMin = villageChance > 0 ? 1 : 0;
        JigsawPattern plains = new JigsawPattern(new ResourceLocation("village/plains/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/town_centers/plains_fountain_01", (StructureProcessorList)ProcessorLists.field_244108_h), (Object)Math.max(villageMin, villageChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/town_centers/plains_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244108_h), (Object)Math.max(villageMin, villageChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/plains/town_centers/plains_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/town_centers/plains_meeting_point_3", (StructureProcessorList)ProcessorLists.field_244109_i), (Object)Math.max(villageMin, villageChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/zombie/town_centers/plains_fountain_01", (StructureProcessorList)ProcessorLists.field_244102_b), (Object)Math.max(1, zombieChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/zombie/town_centers/plains_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244102_b), (Object)Math.max(1, zombieChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/zombie/town_centers/plains_meeting_point_2", (StructureProcessorList)ProcessorLists.field_244102_b), (Object)Math.max(1, zombieChance / 4)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/plains/zombie/town_centers/plains_meeting_point_3", (StructureProcessorList)ProcessorLists.field_244102_b), (Object)Math.max(1, zombieChance / 4))), JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern snowy = new JigsawPattern(new ResourceLocation("village/snowy/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/town_centers/snowy_meeting_point_1"), (Object)Math.max(villageMin, villageChance / 3)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/town_centers/snowy_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 6)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/town_centers/snowy_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 2)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/zombie/town_centers/snowy_meeting_point_1"), (Object)Math.max(1, zombieChance / 3)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/zombie/town_centers/snowy_meeting_point_2"), (Object)Math.max(1, zombieChance / 6)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/snowy/zombie/town_centers/snowy_meeting_point_3"), (Object)Math.max(1, zombieChance / 2))), JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern savanna = new JigsawPattern(new ResourceLocation("village/savanna/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/savanna/town_centers/savanna_meeting_point_1"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 4.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/savanna/town_centers/savanna_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 9)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/savanna/town_centers/savanna_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 3)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/savanna/town_centers/savanna_meeting_point_4"), (Object)Math.max(villageMin, villageChance / 3)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/savanna/zombie/town_centers/savanna_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244103_c), (Object)Math.max(1, (int)((double)zombieChance / 4.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/savanna/zombie/town_centers/savanna_meeting_point_2", (StructureProcessorList)ProcessorLists.field_244103_c), (Object)Math.max(1, zombieChance / 9)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/savanna/zombie/town_centers/savanna_meeting_point_3", (StructureProcessorList)ProcessorLists.field_244103_c), (Object)Math.max(1, zombieChance / 3)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/savanna/zombie/town_centers/savanna_meeting_point_4", (StructureProcessorList)ProcessorLists.field_244103_c), (Object)Math.max(1, zombieChance / 3))), JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern desert = new JigsawPattern(new ResourceLocation("village/desert/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/desert/town_centers/desert_meeting_point_1"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 2.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/desert/town_centers/desert_meeting_point_2"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 2.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242849_a((String)"village/desert/town_centers/desert_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 5)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/desert/zombie/town_centers/desert_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244106_f), (Object)Math.max(1, (int)((double)zombieChance / 2.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/desert/zombie/town_centers/desert_meeting_point_2", (StructureProcessorList)ProcessorLists.field_244106_f), (Object)Math.max(1, (int)((double)zombieChance / 2.5))), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/desert/zombie/town_centers/desert_meeting_point_3", (StructureProcessorList)ProcessorLists.field_244106_f), (Object)Math.max(1, zombieChance / 5))), JigsawPattern.PlacementBehaviour.RIGID);
        JigsawPattern taiga = new JigsawPattern(new ResourceLocation("village/taiga/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/taiga/town_centers/taiga_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244107_g), (Object)Math.max(villageMin, villageChance / 2)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/taiga/town_centers/taiga_meeting_point_2", (StructureProcessorList)ProcessorLists.field_244107_g), (Object)Math.max(villageMin, villageChance / 2)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/taiga/zombie/town_centers/taiga_meeting_point_1", (StructureProcessorList)ProcessorLists.field_244105_e), (Object)Math.max(1, zombieChance / 2)), com.mojang.datafixers.util.Pair.of((Object)JigsawPiece.func_242851_a((String)"village/taiga/zombie/town_centers/taiga_meeting_point_2", (StructureProcessorList)ProcessorLists.field_244105_e), (Object)Math.max(1, zombieChance / 2))), JigsawPattern.PlacementBehaviour.RIGID);
        patterns.put(plains.func_214947_b(), plains);
        patterns.put(snowy.func_214947_b(), snowy);
        patterns.put(savanna.func_214947_b(), savanna);
        patterns.put(desert.func_214947_b(), desert);
        patterns.put(taiga.func_214947_b(), taiga);
    }
}

