/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages;

import com.hostilevillages.HostileVillages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.GroundPathHelper;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomVillageDataSet {
    public static List<DataEntry> possibleMonsters = new ArrayList<DataEntry>();
    public static int totalWeight;
    public static List<ResourceLocation> loottables;
    private DataEntry entry;
    private ItemStack mendingArmor;
    private int spawnedEntities = 0;
    private long worldTimeStart = 0L;

    public RandomVillageDataSet() {
        int chosen = HostileVillages.rand.nextInt(totalWeight);
        int currentWeight = 0;
        for (DataEntry entry : possibleMonsters) {
            if (chosen < entry.weight + currentWeight) {
                this.entry = entry;
                break;
            }
            currentWeight += entry.weight;
        }
        if (this.entry == null) {
            this.entry = possibleMonsters.get(0);
        }
        this.mendingArmor = new ItemStack((IItemProvider)Items.field_151030_Z);
        EnchantmentHelper.func_82782_a(Collections.singletonMap(Enchantments.field_185296_A, 1), (ItemStack)this.mendingArmor);
    }

    public EntityType getEntityReplacement() {
        return HostileVillages.rand.nextInt(this.entry.secondaryChance) > 0 ? this.entry.main : this.entry.secondary;
    }

    public void onEntitySpawn(MobEntity entity, IServerWorld world) {
        ++this.spawnedEntities;
        if (entity.func_70668_bt() == CreatureAttribute.field_223223_b_ && entity.func_104002_bU()) {
            entity.func_184201_a(EquipmentSlotType.HEAD, Items.field_151024_Q.func_190903_i());
        }
        entity.func_213386_a(world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.STRUCTURE, null, null);
        entity.field_70714_bg.func_75776_a(0, (Goal)new BreakDoorGoal(entity, difficulty -> true));
        if (GroundPathHelper.func_242319_a((MobEntity)entity)) {
            ((GroundPathNavigator)entity.func_70661_as()).func_179688_b(true);
        }
        if (!((Boolean)HostileVillages.config.getCommonConfig().generateLoot.get()).booleanValue()) {
            return;
        }
        if (entity.func_104002_bU() && this.spawnedEntities > 12 && this.mendingArmor != null && (entity.func_70668_bt() == CreatureAttribute.field_223223_b_ || entity.func_70668_bt() == CreatureAttribute.field_223225_d_)) {
            entity.func_184201_a(EquipmentSlotType.CHEST, this.mendingArmor);
            entity.func_233663_d_(EquipmentSlotType.CHEST);
            this.mendingArmor = null;
        }
        if (entity.func_104002_bU() && this.spawnedEntities > 12 && HostileVillages.rand.nextInt(20) == 0) {
            ChestMinecartEntity en = (ChestMinecartEntity)EntityType.field_200773_M.func_200721_a((World)world.func_201672_e());
            en.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            world.func_217376_c((Entity)en);
            en.func_184289_a(loottables.get(HostileVillages.rand.nextInt(loottables.size())), (long)HostileVillages.rand.nextInt(509));
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue()) {
                for (int i = 0; i < 27; ++i) {
                    if (en.func_70301_a(i).func_77973_b() != Items.field_190931_a) continue;
                    en.func_70299_a(i, Items.field_196172_da.func_190903_i());
                    break;
                }
            }
        }
    }

    public boolean isValid(World world) {
        return world.func_82737_E() - this.worldTimeStart < 2400L;
    }

    public void setWorldTimeStart(long worldTimeStart) {
        this.worldTimeStart = worldTimeStart;
    }

    public static void parseFromConfig() {
        totalWeight = 0;
        possibleMonsters = new ArrayList<DataEntry>();
        loottables = new ArrayList<ResourceLocation>();
        for (String entry : (List)HostileVillages.config.getCommonConfig().villageEntityTypes.get()) {
            int weight;
            int secondaryChance;
            String[] splitEntry = entry.split(";");
            if (splitEntry.length != 4) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, wrong amount of parameters: " + entry);
                continue;
            }
            ResourceLocation main = ResourceLocation.func_208304_a((String)splitEntry[0]);
            if (main == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + splitEntry[0]);
                continue;
            }
            EntityType mainType = (EntityType)ForgeRegistries.ENTITIES.getValue(main);
            if (mainType == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid entity type" + splitEntry[0]);
                continue;
            }
            ResourceLocation secondary = ResourceLocation.func_208304_a((String)splitEntry[1]);
            if (secondary == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + splitEntry[1]);
                continue;
            }
            EntityType secondaryType = (EntityType)ForgeRegistries.ENTITIES.getValue(secondary);
            if (secondaryType == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid entity type" + splitEntry[1]);
                continue;
            }
            try {
                secondaryChance = Integer.parseInt(splitEntry[2]);
                weight = Integer.parseInt(splitEntry[3]);
            }
            catch (Exception e) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a number" + splitEntry[2] + splitEntry[3]);
                continue;
            }
            totalWeight += weight;
            possibleMonsters.add(new DataEntry(mainType, secondaryType, secondaryChance, weight));
        }
        for (String entry : (List)HostileVillages.config.getCommonConfig().loottables.get()) {
            ResourceLocation lootID = ResourceLocation.func_208304_a((String)entry);
            if (lootID == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entry);
                continue;
            }
            loottables.add(lootID);
        }
    }

    static {
        loottables = new ArrayList<ResourceLocation>();
    }

    static class DataEntry {
        final EntityType main;
        final EntityType secondary;
        final int weight;
        final int secondaryChance;

        private DataEntry(EntityType main, EntityType secondary, int secondaryChance, int weight) {
            this.main = main;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.weight = weight;
        }
    }
}

