/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages.command;

import com.hostilevillages.command.IMCCommand;
import com.hostilevillages.command.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;

public class CommandFindPersistent
implements IMCOPCommand {
    private static Set<Entity> visited = new HashSet<Entity>();

    @Override
    public int onExecute(CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        if (source.func_197022_f() == null) {
            return 0;
        }
        this.searchAndTP(source);
        return 0;
    }

    private void searchAndTP(CommandSource source) {
        PlayerEntity player = (PlayerEntity)source.func_197022_f();
        int killedEntities = 0;
        for (Entity searchEntity : ((ServerWorld)player.field_70170_p).func_241136_z_()) {
            if (searchEntity instanceof ChestMinecartEntity && !visited.contains(searchEntity)) {
                visited.add(searchEntity);
                player.func_70634_a(searchEntity.func_226277_ct_(), searchEntity.func_226278_cu_(), searchEntity.func_226281_cx_());
                source.func_197030_a((ITextComponent)new StringTextComponent("Found entity:" + searchEntity.func_145748_c_().getString()), false);
                break;
            }
            if (!(searchEntity instanceof MobEntity) || searchEntity instanceof INPC) continue;
            if (searchEntity.func_226278_cu_() < 60.0 && ((MobEntity)searchEntity).func_104002_bU() && (((MobEntity)searchEntity).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == Items.field_151024_Q || ((MobEntity)searchEntity).func_184582_a(EquipmentSlotType.CHEST).func_77973_b() == Items.field_151030_Z && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)((MobEntity)searchEntity).func_184582_a(EquipmentSlotType.CHEST)) > 0)) {
                searchEntity.func_70106_y();
                ++killedEntities;
                continue;
            }
            if (searchEntity instanceof AnimalEntity && searchEntity.field_70170_p.func_226660_f_(searchEntity.func_233580_cy_()) || !((MobEntity)searchEntity).func_104002_bU() || visited.contains(searchEntity)) continue;
            boolean isInStructure = false;
            for (Map.Entry entry : ((ServerWorld)searchEntity.field_70170_p).func_212866_a_(searchEntity.field_70176_ah, searchEntity.field_70164_aj).func_201609_c().entrySet()) {
                if (!((StructureStart)entry.getValue()).func_75071_a().func_175898_b((Vector3i)searchEntity.func_233580_cy_())) continue;
                isInStructure = true;
                break;
            }
            if (isInStructure) continue;
            visited.add(searchEntity);
            player.func_70634_a(searchEntity.func_226277_ct_(), searchEntity.func_226278_cu_(), searchEntity.func_226281_cx_());
            source.func_197030_a((ITextComponent)new StringTextComponent("Found entity:" + searchEntity.func_145748_c_().getString()), false);
            source.func_197030_a((ITextComponent)new StringTextComponent("Killed entities:" + killedEntities), false);
            break;
        }
    }

    @Override
    public String getName() {
        return "tpToPersistent";
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("clear", StringArgumentType.string()).executes(this::clearVisited))).executes(this::checkPreConditionAndExecute);
    }

    private int clearVisited(CommandContext<CommandSource> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Cleared visited entity list"), false);
        visited = new HashSet<Entity>();
        return 0;
    }
}

