/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages.event;

import com.hostilevillages.HostileVillages;
import com.hostilevillages.RandomVillageDataSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static final int MAX_VILLAGE_DISTANCE = 40000;
    private static BlockPos lastSpawn = BlockPos.field_177992_a;
    private static RandomVillageDataSet villageDataSet = new RandomVillageDataSet();
    private static List<Tuple<Entity, World>> toAdd = new ArrayList<Tuple<Entity, World>>();
    private static EntityType excludedZombieVillager;

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity().func_200600_R() != EntityType.field_200727_aF || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        excludedZombieVillager = event.getEntity().func_200600_R();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void preLivingConversionEvent(LivingConversionEvent.Pre event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getOutcome() == EntityType.field_200727_aF) {
            excludedZombieVillager = event.getOutcome();
        }
    }

    @SubscribeEvent
    public static void onEntityAdd(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntity().func_200600_R() == excludedZombieVillager) {
            excludedZombieVillager = null;
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue()) {
                return;
            }
        }
        if (EventHandler.replaceEntityOnSpawn(event.getEntity(), (IServerWorld)event.getWorld())) {
            event.setCanceled(true);
        }
    }

    private static boolean replaceEntityOnSpawn(Entity entity, IServerWorld world) {
        if (entity.func_200600_R() == EntityType.field_200756_av || entity.func_200600_R() == EntityType.field_200727_aF) {
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue() && entity.func_200600_R() == EntityType.field_200756_av) {
                return false;
            }
            if (entity.func_233580_cy_().func_177951_i((Vector3i)lastSpawn) > 40000.0 || villageDataSet != null && !villageDataSet.isValid(entity.field_70170_p)) {
                villageDataSet = new RandomVillageDataSet();
                villageDataSet.setWorldTimeStart(entity.field_70170_p.func_82737_E());
            }
            lastSpawn = entity.func_233580_cy_();
            if (villageDataSet == null) {
                return false;
            }
            entity.func_70106_y();
            boolean requirePersistance = entity instanceof MobEntity && ((MobEntity)entity).func_104002_bU();
            for (int i = 0; i < (Integer)HostileVillages.config.getCommonConfig().hostilePopulationSize.get(); ++i) {
                Entity replacementEntity = villageDataSet.getEntityReplacement().func_200721_a((World)world.func_201672_e());
                if (!(replacementEntity instanceof MobEntity)) continue;
                if (requirePersistance) {
                    ((MobEntity)replacementEntity).func_110163_bv();
                } else if (replacementEntity.func_200600_R().func_220339_d().func_82705_e() || ((MobEntity)replacementEntity).func_104002_bU()) continue;
                if (((Boolean)HostileVillages.config.getCommonConfig().debugLog.get()).booleanValue()) {
                    HostileVillages.LOGGER.info("Replacing entity: " + entity + " with entity: " + replacementEntity + " persistence:" + ((MobEntity)replacementEntity).func_104002_bU());
                }
                replacementEntity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                toAdd.add((Tuple<Entity, World>)new Tuple((Object)replacementEntity, (Object)world.func_201672_e()));
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void addToWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.world.field_72995_K) {
            return;
        }
        if (!toAdd.isEmpty()) {
            Tuple<Entity, World> tuple = toAdd.remove(0);
            ((World)tuple.func_76340_b()).func_217376_c((Entity)tuple.func_76341_a());
            if (villageDataSet != null && tuple.func_76341_a() instanceof MobEntity) {
                villageDataSet.onEntitySpawn((MobEntity)tuple.func_76341_a(), (IServerWorld)event.world);
            }
        }
    }
}

