/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.objects.entity.EntityArcher;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class IllagerArcherTowerPieces {
    private static final ResourceLocation tower = new ResourceLocation("illagers_plus", "illager_archer_tower");

    public static void addPieces(TemplateManager manager, BlockPos pos, Rotation rot, List<StructurePiece> components, Random rand) {
        Tower t = new Tower(manager, tower, pos, 0, rot);
        components.add((StructurePiece)t);
        t.func_74861_a((StructurePiece)t, components, rand);
    }

    public static class Tower
    extends TemplateStructurePiece {
        private final ResourceLocation template_name;
        private final Rotation rot;

        public Tower(TemplateManager manager, ResourceLocation location, BlockPos pos, int offset, Rotation rotation) {
            super(ModStructurePieceTypes.IAT, 0);
            this.template_name = location;
            this.rot = rotation;
            this.field_186178_c = pos.func_177981_b(offset);
            this.setup(manager);
        }

        public Tower(TemplateManager templateManager, CompoundNBT compoundNBT) {
            super(ModStructurePieceTypes.IAT, compoundNBT);
            this.template_name = new ResourceLocation(compoundNBT.func_74779_i("Template"));
            this.rot = Rotation.valueOf((String)compoundNBT.func_74779_i("Rot"));
            this.setup(templateManager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.template_name);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rot).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.template_name.toString());
            tagCompound.func_74778_a("Rot", this.rot.toString());
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos cPos) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, cPos);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("archer_tower".equals(function)) {
                LockableLootTileEntity.func_195479_a((IBlockReader)worldIn, (Random)rand, (BlockPos)pos.func_177977_b(), (ResourceLocation)IllagerPlusLootTable.ILLAGER_ARCHER_TOWER);
            }
            if ("spawnArcher".equals(function)) {
                EntityArcher archer = (EntityArcher)EntityInit.ARCHER.func_200721_a(worldIn.func_201672_e());
                archer.func_110163_bv();
                archer.func_174828_a(pos, 0.0f, 0.0f);
                archer.func_213386_a(worldIn, worldIn.func_175649_E(new BlockPos((Entity)archer)), SpawnReason.STRUCTURE, null, null);
                worldIn.func_217376_c((Entity)archer);
            }
        }
    }
}

