/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus.world.structures.pieces;

import com.litewolf101.illagers_plus.init.EntityInit;
import com.litewolf101.illagers_plus.utils.IllagerPlusLootTable;
import com.litewolf101.illagers_plus.world.ModStructurePieceTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RedstoneOreBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.registries.ForgeRegistries;

public class IllagerTowerPieces {
    public static final ResourceLocation corner1 = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_c1");
    public static final ResourceLocation corner2 = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_c2");
    public static final ResourceLocation corner3 = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_c3");
    public static final ResourceLocation corner4 = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_c4");
    public static final ResourceLocation nothing = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_dissapoint");
    public static final ResourceLocation archery = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_archery");
    public static final ResourceLocation brewery = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_brewery");
    public static final ResourceLocation trees = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_dendrology");
    public static final ResourceLocation library = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_library");
    public static final ResourceLocation locked = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_locked");
    public static final ResourceLocation wealth = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_wealth");
    public static final ResourceLocation zombies = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_zombies");
    public static final ResourceLocation top = new ResourceLocation("illagers_plus", "illager_tower/illager_tower_top");

    public static void createTower(TemplateManager manager, BlockPos pos, List<StructurePiece> components, Random rand) {
        BaseCorner1 base = new BaseCorner1(corner1, manager, pos);
        components.add((StructurePiece)base);
        base.func_74861_a((StructurePiece)base, components, rand);
    }

    public static void createRandomFloorPiece(TemplateManager manager, BlockPos pos, List<StructurePiece> components, Random rand) {
        TemplateStructurePiece piece = new TowerFloorNothing(nothing, manager, pos);
        int r = rand.nextInt(100);
        if (r < 20) {
            piece = new TowerFloorArchery(archery, manager, pos);
        } else if (r < 35) {
            piece = new TowerFloorTrees(trees, manager, pos);
        } else if (r < 53) {
            piece = new TowerFloorZombies(zombies, manager, pos);
        } else if (r < 62) {
            piece = new TowerFloorLockedRooms(locked, manager, pos);
        } else if (r < 74) {
            piece = new TowerFloorBrewery(brewery, manager, pos);
        } else if (r < 83) {
            piece = new TowerFloorLibrary(library, manager, pos);
        } else if (r < 85) {
            piece = new TowerFloorWealth(wealth, manager, pos);
        }
        components.add((StructurePiece)piece);
    }

    public static Block generateRandomOre(Random random) {
        ArrayList<Block> ores = new ArrayList<Block>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof OreBlock) && !(block instanceof RedstoneOreBlock)) continue;
            ores.add(block);
        }
        int i = random.nextInt(ores.size());
        return (Block)ores.get(i);
    }

    public static void setAir(IWorld world, BlockPos pos) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
    }

    public static void spawnEntity(IWorld world, BlockPos pos, EntityType type) {
        Entity entity = type.func_200721_a(world.func_201672_e());
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_110163_bv();
            entity.func_174828_a(pos, 0.0f, 0.0f);
            ((MobEntity)entity).func_213386_a(world, world.func_175649_E(new BlockPos(entity)), SpawnReason.STRUCTURE, (ILivingEntityData)null, (CompoundNBT)null);
            world.func_217376_c(entity);
        }
    }

    public static void createRandomFlowerPot(IWorld world, BlockPos pos, Random rand) {
        ArrayList<Block> pots = new ArrayList<Block>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof FlowerPotBlock)) continue;
            pots.add(block);
        }
        int i = rand.nextInt(pots.size());
        Block pot = (Block)pots.get(i);
        world.func_180501_a(pos, pot.func_176223_P(), 2);
    }

    public static class BaseCorner1
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public BaseCorner1(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITC1, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public BaseCorner1(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITC1, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnEnchanter".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ENCHANTER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("randomFlower".equals(function)) {
                IllagerTowerPieces.createRandomFlowerPot(worldIn, pos, rand);
            }
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            BaseCorner2 corner = new BaseCorner2(corner2, this.manager, this.field_186178_c.func_177982_a(0, 0, 16));
            listIn.add((StructurePiece)corner);
            corner.func_74861_a((StructurePiece)corner, listIn, rand);
        }
    }

    public static class BaseCorner2
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public BaseCorner2(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITC2, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public BaseCorner2(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITC2, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnEnchanter".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ENCHANTER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("randomFlower".equals(function)) {
                IllagerTowerPieces.createRandomFlowerPot(worldIn, pos, rand);
            }
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
            if ("eyeBlock".equals(function)) {
                int r = rand.nextInt(100);
                if (r < 60) {
                    worldIn.func_180501_a(pos, Blocks.field_196720_fB.func_176223_P(), 2);
                } else if (r < 80) {
                    worldIn.func_180501_a(pos, Blocks.field_196569_aY.func_176223_P(), 2);
                } else if (r < 95) {
                    worldIn.func_180501_a(pos, Blocks.field_150475_bE.func_176223_P(), 2);
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            BaseCorner3 corner = new BaseCorner3(corner3, this.manager, this.field_186178_c.func_177982_a(16, 0, 0));
            listIn.add((StructurePiece)corner);
            corner.func_74861_a((StructurePiece)corner, listIn, rand);
        }
    }

    public static class BaseCorner3
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public BaseCorner3(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITC3, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public BaseCorner3(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITC3, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnEnchanter".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ENCHANTER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("randomFlower".equals(function)) {
                IllagerTowerPieces.createRandomFlowerPot(worldIn, pos, rand);
            }
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
            if ("eyeBlock".equals(function)) {
                int r = rand.nextInt(100);
                if (r < 60) {
                    worldIn.func_180501_a(pos, Blocks.field_196720_fB.func_176223_P(), 2);
                } else if (r < 80) {
                    worldIn.func_180501_a(pos, Blocks.field_196569_aY.func_176223_P(), 2);
                } else if (r < 95) {
                    worldIn.func_180501_a(pos, Blocks.field_150475_bE.func_176223_P(), 2);
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            BaseCorner4 corner = new BaseCorner4(corner4, this.manager, this.field_186178_c.func_177982_a(0, 0, -16));
            listIn.add((StructurePiece)corner);
            corner.func_74861_a((StructurePiece)corner, listIn, rand);
        }
    }

    public static class BaseCorner4
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public BaseCorner4(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITC4, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public BaseCorner4(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITC4, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnEnchanter".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ENCHANTER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("randomFlower".equals(function)) {
                IllagerTowerPieces.createRandomFlowerPot(worldIn, pos, rand);
            }
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = rand.nextInt(8);
            for (int y = 0; y <= i; ++y) {
                IllagerTowerPieces.createRandomFloorPiece(this.manager, this.field_186178_c.func_177982_a(-8, 17 + 8 * y, 8), listIn, rand);
                if (y != i) continue;
                TowerTop tip = new TowerTop(top, this.manager, this.field_186178_c.func_177982_a(-8, 17 + 8 * (i + 1), 8));
                listIn.add((StructurePiece)tip);
            }
        }
    }

    public static class TowerFloorNothing
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorNothing(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFNOTHING, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorNothing(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFNOTHING, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorArchery
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorArchery(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFARCHERY, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorArchery(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFARCHERY, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
            if ("chestArcher".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_ARCHERY, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorBrewery
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorBrewery(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFBREWERY, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorBrewery(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFBREWERY, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestCommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_COMMON, null);
            }
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("chestBrewing".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_BREWING, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorTrees
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorTrees(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFTREES, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorTrees(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFTREES, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestWood".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_DENDROLOGY, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorLibrary
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorLibrary(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFLIBRARY, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorLibrary(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFLIBRARY, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestUncommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_UNCOMMON, null);
            }
            if ("spawnEvoker".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityType.field_200806_t);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnNecromancer".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.NECROMANCER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("chestEnchant".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_ENCHANTING, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorWealth
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorWealth(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFWEALTH, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorWealth(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFWEALTH, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestUncommon".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_UNCOMMON, null);
            }
            if ("chestRare".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_RARE, null);
            }
            if ("randomOre".equals(function)) {
                for (int x = 0; x <= 14; ++x) {
                    for (int y = 0; y <= 4; ++y) {
                        for (int z = 0; z <= 1; ++z) {
                            worldIn.func_180501_a(pos.func_177982_a(x, y, z), IllagerTowerPieces.generateRandomOre(rand).func_176223_P(), 2);
                        }
                    }
                }
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorZombies
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorZombies(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFZOMBIE, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorZombies(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFZOMBIE, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestRare".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_RARE, null);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerFloorLockedRooms
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerFloorLockedRooms(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITFLOCKED, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerFloorLockedRooms(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITFLOCKED, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestRare".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_RARE, null);
            }
            if ("spawnFurantur".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.FURANTUR);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnEnchanter".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ENCHANTER);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
            if ("spawnVindicator".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityType.field_200758_ax);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }

    public static class TowerTop
    extends TemplateStructurePiece {
        private final ResourceLocation templateName;
        private final TemplateManager manager;

        public TowerTop(ResourceLocation name, TemplateManager manager, BlockPos pos) {
            super(ModStructurePieceTypes.ITTOP, 0);
            this.templateName = name;
            this.manager = manager;
            this.field_186178_c = pos;
            this.setup(manager);
        }

        public TowerTop(TemplateManager manager, CompoundNBT nbt) {
            super(ModStructurePieceTypes.ITTOP, nbt);
            this.templateName = new ResourceLocation(nbt.func_74779_i("Template"));
            this.manager = manager;
            this.setup(manager);
        }

        private void setup(TemplateManager manager) {
            Template template = manager.func_200220_a(this.templateName);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(Rotation.NONE).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName.toString());
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("chestRare".equals(function)) {
                this.func_191080_a(worldIn, sbb, rand, pos, IllagerPlusLootTable.IT_RARE, null);
            }
            if ("randomOreBlock".equals(function)) {
                Block block = Blocks.field_150402_ci;
                int r = rand.nextInt(100);
                if (r < 10) {
                    block = Blocks.field_150339_S;
                } else if (r < 15) {
                    block = Blocks.field_150340_R;
                } else if (r < 30) {
                    block = Blocks.field_150451_bX;
                } else if (r < 40) {
                    block = Blocks.field_150368_y;
                } else if (r < 47) {
                    block = Blocks.field_150371_ca;
                } else if (r < 48) {
                    block = Blocks.field_150484_ah;
                } else if (r < 50) {
                    block = Blocks.field_150475_bE;
                }
                worldIn.func_180501_a(pos, block.func_176223_P(), 2);
            }
            if ("spawnIllagerKing".equals(function)) {
                IllagerTowerPieces.spawnEntity(worldIn, pos, EntityInit.ILLAGER_KING);
                IllagerTowerPieces.setAir(worldIn, pos);
            }
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox structureBoundingBoxIn, ChunkPos p_74875_4_) {
            return super.func_74875_a(worldIn, randomIn, structureBoundingBoxIn, p_74875_4_);
        }
    }
}

