/*
 * Decompiled with CFR 0.152.
 */
package com.litewolf101.illagers_plus;

import com.litewolf101.illagers_plus.client.render.RenderRegistry;
import com.litewolf101.illagers_plus.event.MakeIllagersPlusActuallyEvilEvent;
import com.litewolf101.illagers_plus.init.IllagersPlusItemGroup;
import com.litewolf101.illagers_plus.world.AddBiomeDecoConfig;
import com.litewolf101.illagers_plus.world.ModFeatures;
import net.minecraft.item.ItemGroup;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="illagers_plus")
public class IllagersPlus {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ItemGroup ILLAGERS_PLUS = new IllagersPlusItemGroup();
    public static final String MOD_ID = "illagers_plus";

    public IllagersPlus() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MakeIllagersPlusActuallyEvilEvent());
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        RenderRegistry.registerEntityRenders();
        LOGGER.info("Made things look pretty");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
            LOGGER.info("Adding Illager Features to the world");
            for (Biome biome : Biome.field_201870_ab) {
                AddBiomeDecoConfig.addStructuretoBiome(biome, (IFeatureConfig)IFeatureConfig.field_202429_e, ModFeatures.ILLAGER_ARCHER_TOWER);
                AddBiomeDecoConfig.addStructuretoBiome(biome, (IFeatureConfig)IFeatureConfig.field_202429_e, ModFeatures.ILLAGER_MINE);
                AddBiomeDecoConfig.addStructuretoBiome(biome, (IFeatureConfig)IFeatureConfig.field_202429_e, ModFeatures.ILLAGER_CENTRE);
                AddBiomeDecoConfig.addStructuretoBiome(biome, (IFeatureConfig)IFeatureConfig.field_202429_e, ModFeatures.ILLAGER_TOWER);
            }
        }
    }
}

