/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.datagen;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.steven.indrev.datagen.DataFactory;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0016\u001a\u00020\u0017H&J\u001b\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ/\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00028\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u001b\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 J'\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00028\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n\u00a2\u0006\u0002\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR)\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lme/steven/indrev/datagen/DataGenerator;", "T", "P", "", "dir", "Ljava/io/File;", "namespace", "", "fallback", "Lkotlin/Function1;", "Lme/steven/indrev/datagen/DataFactory;", "(Ljava/io/File;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDir", "()Ljava/io/File;", "getFallback", "()Lkotlin/jvm/functions/Function1;", "generators", "Ljava/util/HashMap;", "getGenerators", "()Ljava/util/HashMap;", "getNamespace", "()Ljava/lang/String;", "generate", "", "", "identifier", "Lnet/minecraft/util/Identifier;", "obj", "(Lnet/minecraft/util/Identifier;Ljava/lang/Object;)Z", "factory", "(Lnet/minecraft/util/Identifier;Ljava/lang/Object;Lme/steven/indrev/datagen/DataFactory;)Z", "get", "(Ljava/lang/Object;)Lme/steven/indrev/datagen/DataFactory;", "register", "", "(Ljava/lang/Object;Lme/steven/indrev/datagen/DataFactory;)V", "indrev"})
public abstract class DataGenerator<T, P> {
    @NotNull
    private final HashMap<T, DataFactory<T, P>> generators;
    @NotNull
    private final File dir;
    @NotNull
    private final String namespace;
    @NotNull
    private final Function1<T, DataFactory<T, P>> fallback;

    @NotNull
    protected final HashMap<T, DataFactory<T, P>> getGenerators() {
        return this.generators;
    }

    @NotNull
    public final DataFactory<T, P> get(T obj) {
        Object object = this.generators.getOrDefault(obj, (DataFactory<T, P>)this.fallback.invoke(obj));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generators.getOrDefault(obj, fallback(obj))");
        return (DataFactory)object;
    }

    public final void register(T obj, @NotNull DataFactory<T, P> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        ((Map)this.generators).put(obj, factory);
    }

    public final boolean generate(@NotNull class_2960 identifier, T obj) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        DataFactory<T, P> jsonFactory = this.get(obj);
        return this.generate(identifier, obj, jsonFactory);
    }

    public final boolean generate(@NotNull class_2960 identifier, T obj, @NotNull DataFactory<T, P> factory) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        File file = new File(this.dir, factory.getFileName(obj, identifier) + '.' + factory.getExtension());
        file.getParentFile().mkdirs();
        P output2 = factory.generate();
        if (output2 != null) {
            file.createNewFile();
            factory.write(file, output2);
            return true;
        }
        return false;
    }

    public abstract int generate();

    @NotNull
    public final File getDir() {
        return this.dir;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final Function1<T, DataFactory<T, P>> getFallback() {
        return this.fallback;
    }

    public DataGenerator(@NotNull File dir, @NotNull String namespace, @NotNull Function1<? super T, ? extends DataFactory<T, P>> fallback) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter(fallback, (String)"fallback");
        this.dir = dir;
        this.namespace = namespace;
        this.fallback = fallback;
        this.generators = new HashMap();
        this.dir.mkdirs();
    }
}

