/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.mixin.common;

import com.mojang.authlib.GameProfile;
import dev.technici4n.fasttransferlib.api.Simulation;
import dev.technici4n.fasttransferlib.api.energy.EnergyIo;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import me.steven.indrev.IndustrialRevolution;
import me.steven.indrev.api.IRServerPlayerEntityExtension;
import me.steven.indrev.items.armor.IRModularArmorItem;
import me.steven.indrev.items.energy.IRPortableChargerItem;
import me.steven.indrev.tools.modular.ArmorModule;
import me.steven.indrev.utils.EnergyApiUtilsKt;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657
implements IRServerPlayerEntityExtension {
    private int ticks = 0;
    private int lastDamageTick = 0;
    private float lastDmg = 0.0f;
    private double lastShield = 0.0;
    private final Object2IntMap<ArmorModule> oldAppliedModules = new Object2IntOpenHashMap();

    @Shadow
    public abstract boolean method_5679(class_1282 var1);

    public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void indrev_applyEffects(CallbackInfo ci) {
        ++this.ticks;
        if (this.ticks % 15 == 0) {
            this.applyArmorEffects();
        }
        this.setShieldDurability(Math.min(this.getShieldDurability(), this.getMaxShieldDurability()));
    }

    @ModifyVariable(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at=@At(value="HEAD"), argsOnly=true)
    private float indrev_absorbDamage(float amount2, class_1282 source) {
        float initial = amount2;
        if (this.method_5679(source)) {
            return amount2;
        }
        if (this.lastDamageTick + 10 > this.ticks) {
            if (amount2 <= this.lastDmg) {
                return 0.0f;
            }
            amount2 -= this.lastDmg;
        }
        this.lastDamageTick = this.ticks;
        this.lastDmg = initial;
        if (this.shouldApplyToShield(source)) {
            return (float)this.applyDamageToShield(amount2);
        }
        return amount2;
    }

    @Inject(method={"worldChanged"}, at={@At(value="TAIL")})
    private void indrev_syncOnDimChange(class_3218 origin, CallbackInfo ci) {
        this.sync();
    }

    private boolean shouldApplyToShield(class_1282 source) {
        if (source.equals(class_1282.field_5868)) {
            return this.isApplied(ArmorModule.FEATHER_FALLING);
        }
        if (source.method_5534()) {
            return this.isApplied(ArmorModule.FIRE_RESISTANCE);
        }
        return !source.equals(class_1282.field_5852) && !source.equals(class_1282.field_5859);
    }

    private void applyArmorEffects() {
        class_3222 player = (class_3222)this;
        class_1661 inventory2 = player.field_7514;
        this.getAppliedModules().clear();
        for (class_1799 itemStack : inventory2.field_7548) {
            if (!(itemStack.method_7909() instanceof IRModularArmorItem)) continue;
            List<ArmorModule> modules = ((IRModularArmorItem)itemStack.method_7909()).getInstalled(itemStack);
            block8: for (ArmorModule module : modules) {
                int level = module.getLevel(itemStack);
                if (level <= 0) continue;
                block0 : switch (module) {
                    case SPEED: 
                    case BREATHING: 
                    case JUMP_BOOST: 
                    case NIGHT_VISION: 
                    case FIRE_RESISTANCE: 
                    case PIGLIN_TRICKER: 
                    case FEATHER_FALLING: {
                        if (!EnergyApiUtilsKt.extract(itemStack, 20.0)) break;
                        this.applyModule(module, level);
                        break;
                    }
                    case AUTO_FEEDER: {
                        class_1702 hunger = player.method_7344();
                        if (!hunger.method_7587()) break;
                        for (int slot = 0; slot <= inventory2.method_5439(); ++slot) {
                            class_1799 stack = inventory2.method_5438(slot);
                            class_4174 food = stack.method_7909().method_19264();
                            if (food != null && food.method_19230() <= 20 - hunger.method_7586() && EnergyApiUtilsKt.extract(itemStack, 30.0)) {
                                stack.method_7910(this.field_6002, (class_1309)player);
                                player.method_18866(this.field_6002, stack);
                            }
                            if (!this.field_7493.method_7587()) break block0;
                        }
                        continue block8;
                    }
                    case CHARGER: {
                        IRPortableChargerItem.Companion.chargeItemsInInv(itemStack, (class_2371<class_1799>)player.field_7514.field_7547);
                        break;
                    }
                    case SOLAR_PANEL: {
                        if (!this.field_6002.method_8530() || !this.field_6002.method_8311(player.method_24515().method_10086(2))) break;
                        for (class_1799 stackToCharge : inventory2.field_7548) {
                            EnergyIo toCharge = EnergyApiUtilsKt.energyOf(stackToCharge);
                            if (toCharge == null) continue;
                            toCharge.insert(75.0 * (double)level, Simulation.ACT);
                        }
                        continue block8;
                    }
                    case PROTECTION: {
                        if (this.ticks - 120 <= this.lastDamageTick || !(this.getShieldDurability() < this.getMaxShieldDurability()) || !EnergyApiUtilsKt.extract(itemStack, 30.0)) break;
                        this.regenerateShield();
                        break;
                    }
                }
            }
        }
    }

    private void regenerateShield() {
        this.setShieldDurability(Math.min(this.getShieldDurability() + 0.5, this.getMaxShieldDurability()));
    }

    private double applyDamageToShield(double damage) {
        double absorbed = Math.min(damage, this.getShieldDurability());
        this.setShieldDurability(this.getShieldDurability() - absorbed);
        return damage - absorbed;
    }

    @Override
    public boolean shouldSync() {
        return !this.oldAppliedModules.equals((Object)this.getAppliedModules()) || this.lastShield != this.getShieldDurability();
    }

    @Override
    public void sync() {
        this.lastShield = this.getShieldDurability();
        this.oldAppliedModules.clear();
        this.oldAppliedModules.putAll(this.getAppliedModules());
        class_2540 buf = new class_2540(Unpooled.buffer());
        Map appliedModules = this.getAppliedModules();
        buf.writeInt(appliedModules.size());
        appliedModules.forEach((module, level) -> {
            buf.writeInt(module.ordinal());
            buf.writeInt(level.intValue());
        });
        buf.writeDouble(this.getShieldDurability());
        buf.writeBoolean(this.ticks - 120 > this.lastDamageTick);
        ServerPlayNetworking.send((class_3222)((class_3222)this), (class_2960)IndustrialRevolution.INSTANCE.getSYNC_MODULE_PACKET(), (class_2540)buf);
    }

    @Override
    public boolean isRegenerating() {
        return this.ticks - 120 > this.lastDamageTick;
    }
}

