/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.recipes.machines;

import alexiil.mc.lib.attributes.fluid.amount.FluidAmount;
import alexiil.mc.lib.attributes.fluid.volume.FluidEntry;
import alexiil.mc.lib.attributes.fluid.volume.FluidKey;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import me.steven.indrev.recipes.machines.IRRecipe;
import me.steven.indrev.recipes.machines.entries.InputEntry;
import me.steven.indrev.recipes.machines.entries.OutputEntry;
import me.steven.indrev.utils.UtilsKt;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lme/steven/indrev/recipes/machines/IRRecipe;", "()V", "fluidInput", "Lalexiil/mc/lib/attributes/fluid/volume/FluidVolume;", "getFluidInput", "()Lalexiil/mc/lib/attributes/fluid/volume/FluidVolume;", "fluidOutput", "getFluidOutput", "matches", "", "inv", "", "Lnet/minecraft/item/ItemStack;", "fluidVolume", "IRFluidRecipeSerializer", "indrev"})
public abstract class IRFluidRecipe
implements IRRecipe {
    @Nullable
    public abstract FluidVolume getFluidInput();

    @Nullable
    public abstract FluidVolume getFluidOutput();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull List<class_1799> inv, @Nullable FluidVolume fluidVolume) {
        Intrinsics.checkNotNullParameter(inv, (String)"inv");
        if (fluidVolume == null) {
            return false;
        }
        if (this.getFluidInput() != null) {
            FluidKey fluidKey = fluidVolume.fluidKey;
            FluidVolume fluidVolume2 = this.getFluidInput();
            Intrinsics.checkNotNull((Object)fluidVolume2);
            if (!Intrinsics.areEqual((Object)fluidKey, (Object)fluidVolume2.fluidKey)) return false;
            FluidAmount fluidAmount = fluidVolume.amount();
            FluidVolume fluidVolume3 = this.getFluidInput();
            Intrinsics.checkNotNull((Object)fluidVolume3);
            if (fluidAmount.compareTo(fluidVolume3.amount()) < 0) return false;
            if (!IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume)) return false;
            return true;
        }
        boolean bl = IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, fluidVolume);
        return bl;
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(imports={}, expression="matches(Inventory, FluidVolume?)"), level=DeprecationLevel.ERROR)
    public boolean method_8115(@Nullable class_1263 inv, @Nullable class_1937 world) {
        return IRRecipe.DefaultImpls.matches((IRRecipe)this, inv, world);
    }

    @Override
    @NotNull
    public class_2960 method_8114() {
        return IRRecipe.DefaultImpls.getId(this);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(imports={}, expression="craft(Random)"), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8116(@Nullable class_1263 inv) {
        return IRRecipe.DefaultImpls.craft((IRRecipe)this, inv);
    }

    @Override
    @NotNull
    public List<class_1799> craft(@Nullable Random random) {
        return IRRecipe.DefaultImpls.craft((IRRecipe)this, random);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(imports={}, expression="output"), level=DeprecationLevel.ERROR)
    @NotNull
    public class_1799 method_8110() {
        return IRRecipe.DefaultImpls.getOutput(this);
    }

    @Override
    @Deprecated(message="Unsupported method for Industrial Revolution's recipes", replaceWith=@ReplaceWith(imports={}, expression="input"), level=DeprecationLevel.ERROR)
    @NotNull
    public class_2371<class_1856> method_8117() {
        return IRRecipe.DefaultImpls.getPreviewInputs(this);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003BG\u0012@\u0010\u0004\u001a<\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018RH\u0010\u0004\u001a<\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/steven/indrev/recipes/machines/IRFluidRecipe$IRFluidRecipeSerializer;", "T", "Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "Lnet/minecraft/recipe/RecipeSerializer;", "factory", "Lkotlin/Function6;", "Lnet/minecraft/util/Identifier;", "", "Lme/steven/indrev/recipes/machines/entries/InputEntry;", "Lme/steven/indrev/recipes/machines/entries/OutputEntry;", "Lalexiil/mc/lib/attributes/fluid/volume/FluidVolume;", "", "(Lkotlin/jvm/functions/Function6;)V", "read", "id", "json", "Lcom/google/gson/JsonObject;", "(Lnet/minecraft/util/Identifier;Lcom/google/gson/JsonObject;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "buf", "Lnet/minecraft/network/PacketByteBuf;", "(Lnet/minecraft/util/Identifier;Lnet/minecraft/network/PacketByteBuf;)Lme/steven/indrev/recipes/machines/IRFluidRecipe;", "write", "", "recipe", "(Lnet/minecraft/network/PacketByteBuf;Lme/steven/indrev/recipes/machines/IRFluidRecipe;)V", "indrev"})
    public static class IRFluidRecipeSerializer<T extends IRFluidRecipe>
    implements class_1865<T> {
        private final Function6<class_2960, InputEntry[], OutputEntry[], FluidVolume, FluidVolume, Integer, T> factory;

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull class_2540 buf) {
            FluidVolume fluidVolume;
            FluidVolume fluidVolume2;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int ticks = buf.readInt();
            boolean hasInputFluid = buf.readBoolean();
            if (hasInputFluid) {
                class_2960 fluidId = buf.method_10810();
                FluidAmount fluidAmount = FluidAmount.fromMcBuffer((class_2540)buf);
                FluidKey fluidKey = FluidKeys.get((class_3611)((class_3611)class_2378.field_11154.method_10223(fluidId)));
                fluidVolume2 = fluidKey.withAmount(fluidAmount);
            } else {
                fluidVolume2 = null;
            }
            FluidVolume fluidInput = fluidVolume2;
            boolean hasOutputFluid = buf.readBoolean();
            if (hasOutputFluid) {
                class_2960 fluidId = buf.method_10810();
                FluidAmount fluidAmount = FluidAmount.fromMcBuffer((class_2540)buf);
                FluidKey fluidKey = FluidKeys.get((class_3611)((class_3611)class_2378.field_11154.method_10223(fluidId)));
                fluidVolume = fluidKey.withAmount(fluidAmount);
            } else {
                fluidVolume = null;
            }
            FluidVolume fluidOutput = fluidVolume;
            int size = buf.readInt();
            boolean fluidKey = false;
            List ingredients = new ArrayList();
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)size);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int $noName_0 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                class_1856 ingredient = class_1856.method_8086((class_2540)buf);
                int count = buf.readInt();
                class_1856 class_18562 = ingredient;
                Intrinsics.checkNotNullExpressionValue((Object)class_18562, (String)"ingredient");
                ingredients.add(new InputEntry(class_18562, count));
            }
            int outputSize = buf.readInt();
            boolean bl = false;
            List output2 = new ArrayList();
            Iterable $this$forEach$iv2 = (Iterable)RangesKt.until((int)0, (int)outputSize);
            boolean $i$f$forEach2 = false;
            Iterator $noName_0 = $this$forEach$iv2.iterator();
            while ($noName_0.hasNext()) {
                int element$iv;
                int $noName_02 = element$iv = ((IntIterator)$noName_0).nextInt();
                boolean bl2 = false;
                class_1799 stack = buf.method_10819();
                double chance = buf.readDouble();
                class_1799 class_17992 = stack;
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"stack");
                output2.add(new OutputEntry(class_17992, chance));
            }
            Collection $this$toTypedArray$iv = ingredients;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            InputEntry[] inputEntryArray = thisCollection$iv.toArray(new InputEntry[0]);
            if (inputEntryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$toTypedArray$iv = output2;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            OutputEntry[] outputEntryArray = thisCollection$iv.toArray(new OutputEntry[0]);
            if (outputEntryArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)inputEntryArray, (Object)outputEntryArray, (Object)fluidInput, (Object)fluidOutput, (Object)ticks));
        }

        @NotNull
        public T read(@NotNull class_2960 id, @NotNull JsonObject json) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            InputEntry[] ingredients = IRRecipe.Companion.ingredientsFromElement(json.get("ingredients"));
            JsonElement jsonElement = json.get("processTime");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"json.get(\"processTime\")");
            int ticks = jsonElement.getAsInt();
            OutputEntry[] output2 = IRRecipe.Companion.itemStacksFromElement(json.get("output"));
            JsonObject fluidInputJson = json.getAsJsonObject("fluidInput");
            FluidVolume fluidInput = fluidInputJson == null ? null : UtilsKt.getFluidFromJson(fluidInputJson);
            JsonObject fluidOutputJson = json.getAsJsonObject("fluidOutput");
            FluidVolume fluidOutput = fluidOutputJson == null ? FluidKeys.EMPTY.withAmount(FluidAmount.ZERO) : UtilsKt.getFluidFromJson(fluidOutputJson);
            return (T)((IRFluidRecipe)this.factory.invoke((Object)id, (Object)ingredients, (Object)output2, (Object)fluidInput, (Object)fluidOutput, (Object)ticks));
        }

        /*
         * WARNING - void declaration
         */
        public void write(@NotNull class_2540 buf, @NotNull T recipe) {
            class_1799 ingredient;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter(recipe, (String)"recipe");
            buf.writeInt(recipe.getTicks());
            buf.writeBoolean(((IRFluidRecipe)recipe).getFluidInput() != null);
            if (((IRFluidRecipe)recipe).getFluidInput() != null) {
                FluidVolume fluidVolume = ((IRFluidRecipe)recipe).getFluidInput();
                Intrinsics.checkNotNull((Object)fluidVolume);
                FluidEntry fluidEntry = fluidVolume.fluidKey.entry;
                Intrinsics.checkNotNullExpressionValue((Object)fluidEntry, (String)"recipe.fluidInput!!.fluidKey.entry");
                buf.method_10812(fluidEntry.getId());
                FluidVolume fluidVolume2 = ((IRFluidRecipe)recipe).getFluidInput();
                Intrinsics.checkNotNull((Object)fluidVolume2);
                fluidVolume2.amount().toMcBuffer(buf);
            }
            buf.writeBoolean(((IRFluidRecipe)recipe).getFluidOutput() != null);
            if (((IRFluidRecipe)recipe).getFluidOutput() != null) {
                FluidVolume fluidVolume = ((IRFluidRecipe)recipe).getFluidOutput();
                Intrinsics.checkNotNull((Object)fluidVolume);
                FluidEntry fluidEntry = fluidVolume.fluidKey.entry;
                Intrinsics.checkNotNullExpressionValue((Object)fluidEntry, (String)"recipe.fluidOutput!!.fluidKey.entry");
                buf.method_10812(fluidEntry.getId());
                FluidVolume fluidVolume3 = ((IRFluidRecipe)recipe).getFluidOutput();
                Intrinsics.checkNotNull((Object)fluidVolume3);
                fluidVolume3.amount().toMcBuffer(buf);
            }
            buf.writeInt(recipe.getInput().length);
            Object[] $this$forEach$iv = recipe.getInput();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InputEntry $dstr$ingredient$count = element$iv;
                boolean bl = false;
                class_1856 class_18562 = $dstr$ingredient$count.component1();
                int count = $dstr$ingredient$count.component2();
                ingredient.method_8088(buf);
                buf.writeInt(count);
            }
            buf.writeInt(recipe.getOutputs().length);
            $this$forEach$iv = recipe.getOutputs();
            $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                void stack;
                Object element$iv;
                Object $dstr$stack$chance = element$iv = objectArray[j];
                boolean bl = false;
                ingredient = ((OutputEntry)$dstr$stack$chance).component1();
                double chance = ((OutputEntry)$dstr$stack$chance).component2();
                buf.method_10793((class_1799)stack);
                buf.writeDouble(chance);
            }
        }

        public IRFluidRecipeSerializer(@NotNull Function6<? super class_2960, ? super InputEntry[], ? super OutputEntry[], ? super FluidVolume, ? super FluidVolume, ? super Integer, ? extends T> factory) {
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            this.factory = factory;
        }
    }
}

