/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.registry;

import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blocks.machine.DrillHeadModel;
import me.steven.indrev.blocks.models.PumpPipeBakedModel;
import me.steven.indrev.blocks.models.pipes.CableModel;
import me.steven.indrev.blocks.models.pipes.FluidPipeModel;
import me.steven.indrev.blocks.models.pipes.ItemPipeModel;
import me.steven.indrev.items.models.TankItemBakedModel;
import me.steven.indrev.registry.MachineRegistry;
import me.steven.indrev.utils.SimpleBlockModel;
import me.steven.indrev.utils.UtilsKt;
import net.fabricmc.fabric.api.client.model.ExtraModelProvider;
import net.fabricmc.fabric.api.client.model.ModelProviderContext;
import net.fabricmc.fabric.api.client.model.ModelVariantProvider;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/steven/indrev/registry/IRModelManagers;", "Lnet/fabricmc/fabric/api/client/model/ModelVariantProvider;", "Lnet/fabricmc/fabric/api/client/model/ExtraModelProvider;", "()V", "CABLE_MODELS", "", "Lme/steven/indrev/blocks/models/pipes/CableModel;", "[Lme/steven/indrev/blocks/models/pipes/CableModel;", "FLUID_PIPE_MODELS", "Lme/steven/indrev/blocks/models/pipes/FluidPipeModel;", "[Lme/steven/indrev/blocks/models/pipes/FluidPipeModel;", "ITEM_PIPE_MODELS", "Lme/steven/indrev/blocks/models/pipes/ItemPipeModel;", "[Lme/steven/indrev/blocks/models/pipes/ItemPipeModel;", "LFC_OVERLAY_REGEX", "Lkotlin/text/Regex;", "loadModelVariant", "Lnet/minecraft/client/render/model/UnbakedModel;", "resourceId", "Lnet/minecraft/client/util/ModelIdentifier;", "ctx", "Lnet/fabricmc/fabric/api/client/model/ModelProviderContext;", "provideExtraModels", "", "manager", "Lnet/minecraft/resource/ResourceManager;", "out", "Ljava/util/function/Consumer;", "Lnet/minecraft/util/Identifier;", "indrev"})
public final class IRModelManagers
implements ModelVariantProvider,
ExtraModelProvider {
    private static final Regex LFC_OVERLAY_REGEX;
    private static final CableModel[] CABLE_MODELS;
    private static final ItemPipeModel[] ITEM_PIPE_MODELS;
    private static final FluidPipeModel[] FLUID_PIPE_MODELS;
    @NotNull
    public static final IRModelManagers INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public class_1100 loadModelVariant(@NotNull class_1091 resourceId, @Nullable ModelProviderContext ctx) {
        class_1100 class_11002;
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        if (Intrinsics.areEqual((Object)resourceId.method_12836(), (Object)"indrev") ^ true) {
            return null;
        }
        String path = resourceId.method_12832();
        String variant = resourceId.method_4740();
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832());
        if (Intrinsics.areEqual((Object)path, (Object)"drill_head")) {
            String string = resourceId.method_4740();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceId.variant");
            class_11002 = new DrillHeadModel(string);
            return class_11002;
        } else if (Intrinsics.areEqual((Object)path, (Object)"pump_pipe")) {
            class_11002 = new PumpPipeBakedModel();
            return class_11002;
        } else {
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            if (LFC_OVERLAY_REGEX.matches((CharSequence)string)) {
                class_11002 = new SimpleBlockModel(path);
                return class_11002;
            } else if (Intrinsics.areEqual((Object)path, (Object)"tank") && Intrinsics.areEqual((Object)variant, (Object)"inventory")) {
                class_11002 = TankItemBakedModel.INSTANCE;
                return class_11002;
            } else if (StringsKt.startsWith$default((String)path, (String)"cable_mk", (boolean)false, (int)2, null)) {
                String string2 = String.valueOf(StringsKt.last((CharSequence)path));
                boolean bl = false;
                class_11002 = CABLE_MODELS[Integer.parseInt(string2) - 1];
                return class_11002;
            } else if (StringsKt.startsWith$default((String)path, (String)"item_pipe_mk", (boolean)false, (int)2, null)) {
                String string3 = String.valueOf(StringsKt.last((CharSequence)path));
                boolean bl = false;
                class_11002 = ITEM_PIPE_MODELS[Integer.parseInt(string3) - 1];
                return class_11002;
            } else if (StringsKt.startsWith$default((String)path, (String)"fluid_pipe_mk", (boolean)false, (int)2, null)) {
                String string4 = String.valueOf(StringsKt.last((CharSequence)path));
                boolean bl = false;
                class_11002 = FLUID_PIPE_MODELS[Integer.parseInt(string4) - 1];
                return class_11002;
            } else {
                if (!MachineRegistry.Companion.getMAP().containsKey(id)) return null;
                MachineRegistry machineRegistry = MachineRegistry.Companion.getMAP().get(id);
                Object object = machineRegistry;
                if (machineRegistry == null) return null;
                Map<Tier, Function1<String, class_1100>> map = ((MachineRegistry)object).getModelProvider();
                object = map;
                if (map == null) return null;
                Integer n = StringsKt.toIntOrNull((String)String.valueOf(StringsKt.last((CharSequence)path)));
                Function1 function1 = (Function1)object.get((Object)Tier.values()[(n != null ? n : 4) - 1]);
                object = function1;
                if (function1 == null) return null;
                String string5 = id.method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"id.path");
                class_11002 = (class_1100)object.invoke((Object)StringsKt.replace$default((String)string5, (String)"_creative", (String)"_mk4", (boolean)false, (int)4, null));
            }
        }
        return class_11002;
    }

    public void provideExtraModels(@Nullable class_3300 manager, @NotNull Consumer<class_2960> out) {
        Intrinsics.checkNotNullParameter(out, (String)"out");
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "stone"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "iron"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "diamond"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("drill_head"), "netherite"));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("pump_pipe"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_input"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_output"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_item_lf_level"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_mk1_overlay"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_mk2_overlay"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_mk3_overlay"), ""));
        out.accept((class_2960)new class_1091(UtilsKt.identifier("lazuli_flux_container_mk4_overlay"), ""));
    }

    private IRModelManagers() {
    }

    static {
        IRModelManagers iRModelManagers;
        INSTANCE = iRModelManagers = new IRModelManagers();
        LFC_OVERLAY_REGEX = new Regex("lazuli_flux_container_(input|output|item_lf_level|mk[1-4]_overlay)");
        CABLE_MODELS = new CableModel[]{new CableModel(Tier.MK1), new CableModel(Tier.MK2), new CableModel(Tier.MK3), new CableModel(Tier.MK4)};
        ITEM_PIPE_MODELS = new ItemPipeModel[]{new ItemPipeModel(Tier.MK1), new ItemPipeModel(Tier.MK2), new ItemPipeModel(Tier.MK3), new ItemPipeModel(Tier.MK4)};
        FLUID_PIPE_MODELS = new FluidPipeModel[]{new FluidPipeModel(Tier.MK1), new FluidPipeModel(Tier.MK2), new FluidPipeModel(Tier.MK3), new FluidPipeModel(Tier.MK4)};
    }
}

