/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.gui;

import com.github.mrebhan.ingameaccountswitcher.tools.Config;
import com.github.mrebhan.ingameaccountswitcher.tools.Tools;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AccountData;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltDatabase;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltManager;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_358;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;
import the_fireplace.ias.account.AlreadyLoggedInException;
import the_fireplace.ias.account.ExtendedAccountData;
import the_fireplace.ias.config.ConfigValues;
import the_fireplace.ias.gui.GuiAddAccount;
import the_fireplace.ias.gui.GuiEditAccount;
import the_fireplace.ias.tools.HttpTools;
import the_fireplace.ias.tools.JavaTools;
import the_fireplace.ias.tools.SkinTools;
import the_fireplace.iasencrypt.EncryptionTools;

public class GuiAccountSelector
extends class_437 {
    private int selectedAccountIndex = 0;
    private int prevIndex = 0;
    private Throwable loginfailed;
    private ArrayList<ExtendedAccountData> queriedaccounts = this.convertData();
    private List accountsgui;
    private class_4185 login;
    private class_4185 loginoffline;
    private class_4185 delete;
    private class_4185 edit;
    private class_4185 reloadskins;
    private String prevQuery = "";
    private class_342 search;

    public GuiAccountSelector() {
        super((class_2561)new class_2588("ias.selectaccount", new Object[0]));
    }

    protected void init() {
        this.accountsgui = new List(this.minecraft);
        this.children.add(this.accountsgui);
        this.reloadskins = new class_4185(2, 2, 120, 20, class_1074.method_4662((String)"ias.reloadskins", (Object[])new Object[0]), btn -> this.reloadSkins());
        this.addButton((class_339)this.reloadskins);
        this.addButton((class_339)new class_4185(this.width / 2 + 4 + 40, this.height - 52, 120, 20, class_1074.method_4662((String)"ias.addaccount", (Object[])new Object[0]), btn -> this.add()));
        this.login = new class_4185(this.width / 2 - 154 - 10, this.height - 52, 120, 20, class_1074.method_4662((String)"ias.login", (Object[])new Object[0]), btn -> this.login(this.selectedAccountIndex));
        this.addButton((class_339)this.login);
        this.edit = new class_4185(this.width / 2 - 40, this.height - 52, 80, 20, class_1074.method_4662((String)"ias.edit", (Object[])new Object[0]), btn -> this.edit());
        this.addButton((class_339)this.edit);
        this.loginoffline = new class_4185(this.width / 2 - 154 - 10, this.height - 28, 110, 20, class_1074.method_4662((String)"ias.login", (Object[])new Object[0]) + " " + class_1074.method_4662((String)"ias.offline", (Object[])new Object[0]), btn -> this.logino(this.selectedAccountIndex));
        this.addButton((class_339)this.loginoffline);
        this.addButton((class_339)new class_4185(this.width / 2 + 4 + 50, this.height - 28, 110, 20, class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]), btn -> this.escape()));
        this.delete = new class_4185(this.width / 2 - 50, this.height - 28, 100, 20, class_1074.method_4662((String)"ias.delete", (Object[])new Object[0]), btn -> this.delete());
        this.addButton((class_339)this.delete);
        this.search = new class_342(this.font, this.width / 2 - 80, 14, 160, 16, class_1074.method_4662((String)"ias.search", (Object[])new Object[0]));
        this.addButton((class_339)this.search);
        this.updateButtons();
        this.updateShownSkin();
    }

    private void updateShownSkin() {
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.buildSkin(this.queriedaccounts.get((int)this.selectedAccountIndex).alias);
        }
    }

    public void tick() {
        this.updateButtons();
        if (this.prevIndex != this.selectedAccountIndex) {
            this.prevIndex = this.selectedAccountIndex;
            this.updateShownSkin();
        }
        if (!this.prevQuery.equals(this.search.method_1882())) {
            this.updateQueried();
            this.prevQuery = this.search.method_1882();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.accountsgui.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void removed() {
        Config.save();
    }

    public void render(int mx, int my, float delta) {
        this.renderBackground();
        this.accountsgui.render(mx, my, delta);
        this.drawCenteredString(this.font, this.title.method_10863(), this.width / 2, 4, -1);
        if (this.loginfailed != null) {
            this.drawCenteredString(this.font, this.loginfailed.getLocalizedMessage(), this.width / 2, this.height - 62, 0xFF6464);
        }
        super.render(mx, my, delta);
        if (!this.queriedaccounts.isEmpty()) {
            SkinTools.javDrawSkin(8, this.height / 2 - 64 - 16, 64, 128);
            Tools.drawBorderedRect(this.width - 8 - 64, this.height / 2 - 64 - 16, this.width - 8, this.height / 2 + 64 - 16, 2, -5855578, -13421773);
            if (this.queriedaccounts.get((int)this.selectedAccountIndex).premium != null) {
                if (this.queriedaccounts.get((int)this.selectedAccountIndex).premium.booleanValue()) {
                    this.drawString(this.font, class_1074.method_4662((String)"ias.premium", (Object[])new Object[0]), this.width - 8 - 61, this.height / 2 - 64 - 13, 0x64FF64);
                } else {
                    this.drawString(this.font, class_1074.method_4662((String)"ias.notpremium", (Object[])new Object[0]), this.width - 8 - 61, this.height / 2 - 64 - 13, 0xFF6464);
                }
            }
            this.drawString(this.font, class_1074.method_4662((String)"ias.timesused", (Object[])new Object[0]), this.width - 8 - 61, this.height / 2 - 64 - 15 + 12, -1);
            this.drawString(this.font, String.valueOf(this.queriedaccounts.get((int)this.selectedAccountIndex).useCount), this.width - 8 - 61, this.height / 2 - 64 - 15 + 21, -1);
            if (this.queriedaccounts.get((int)this.selectedAccountIndex).useCount > 0) {
                this.drawString(this.font, class_1074.method_4662((String)"ias.lastused", (Object[])new Object[0]), this.width - 8 - 61, this.height / 2 - 64 - 15 + 30, -1);
                this.drawString(this.font, JavaTools.getFormattedDate(), this.width - 8 - 61, this.height / 2 - 64 - 15 + 39, -1);
            }
        }
    }

    private void reloadSkins() {
        Config.save();
        SkinTools.cacheSkins(true);
        this.updateShownSkin();
    }

    private void escape() {
        this.minecraft.method_1507(null);
    }

    private void delete() {
        AltDatabase.getInstance().getAlts().remove(this.getCurrentAsEditable());
        if (this.selectedAccountIndex > 0) {
            --this.selectedAccountIndex;
        }
        this.updateQueried();
        this.updateButtons();
    }

    private void add() {
        this.minecraft.method_1507((class_437)new GuiAddAccount());
    }

    private void logino(int selected) {
        ExtendedAccountData data = this.queriedaccounts.get(selected);
        AltManager.getInstance().setUserOffline(data.alias);
        this.loginfailed = null;
        this.minecraft.method_1507(null);
        ExtendedAccountData current = this.getCurrentAsEditable();
        ++current.useCount;
        current.lastused = JavaTools.getDate();
    }

    private void login(int selected) {
        ExtendedAccountData data = this.queriedaccounts.get(selected);
        this.loginfailed = AltManager.getInstance().setUser(data.user, data.pass);
        if (this.loginfailed == null) {
            this.minecraft.method_1507(null);
            ExtendedAccountData current = this.getCurrentAsEditable();
            current.premium = true;
            ++current.useCount;
            current.lastused = JavaTools.getDate();
        } else if (this.loginfailed instanceof AlreadyLoggedInException) {
            this.getCurrentAsEditable().lastused = JavaTools.getDate();
        } else if (HttpTools.ping("http://minecraft.net")) {
            this.getCurrentAsEditable().premium = false;
        }
    }

    private void edit() {
        this.minecraft.method_1507((class_437)new GuiEditAccount(this.selectedAccountIndex));
    }

    private void updateQueried() {
        this.queriedaccounts = this.convertData();
        if (!this.search.method_1882().trim().isEmpty()) {
            for (int i = 0; i < this.queriedaccounts.size(); ++i) {
                if (!this.queriedaccounts.get((int)i).alias.contains(this.search.method_1882()) && ConfigValues.CASESENSITIVE) {
                    this.queriedaccounts.remove(i);
                    --i;
                    continue;
                }
                if (this.queriedaccounts.get((int)i).alias.toLowerCase().contains(this.search.method_1882().toLowerCase()) || ConfigValues.CASESENSITIVE) continue;
                this.queriedaccounts.remove(i);
                --i;
            }
        }
        if (!this.queriedaccounts.isEmpty()) {
            while (this.selectedAccountIndex >= this.queriedaccounts.size()) {
                --this.selectedAccountIndex;
            }
        }
    }

    public boolean keyPressed(int key, int oldkey, int mods) {
        if (key == 265 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex > 0) {
                --this.selectedAccountIndex;
            }
        } else if (key == 264 && !this.queriedaccounts.isEmpty()) {
            if (this.selectedAccountIndex < this.queriedaccounts.size() - 1) {
                ++this.selectedAccountIndex;
            }
        } else if (key == 256) {
            this.escape();
        } else if (key == 261 && this.delete.active) {
            this.delete();
        } else if (key == 257 && !this.search.isFocused() && (this.login.active || this.loginoffline.active)) {
            if (class_437.hasShiftDown() && this.loginoffline.active) {
                this.logino(this.selectedAccountIndex);
            } else if (this.login.active) {
                this.login(this.selectedAccountIndex);
            }
        } else if (key == 294) {
            this.reloadSkins();
        } else if (this.search.isFocused() && key == 257) {
            this.search.method_1876(false);
            return true;
        }
        return super.keyPressed(key, oldkey, mods);
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean charTyped(char charT, int mods) {
        if (charT == '+') {
            this.add();
        } else if (charT == '/' && this.edit.active) {
            this.edit();
        } else if (!(this.search.isFocused() || charT != 'r' && charT != 'R')) {
            this.reloadSkins();
        }
        return super.charTyped(charT, mods);
    }

    private ArrayList<ExtendedAccountData> convertData() {
        ArrayList tmp = (ArrayList)AltDatabase.getInstance().getAlts().clone();
        ArrayList<ExtendedAccountData> converted = new ArrayList<ExtendedAccountData>();
        int index = 0;
        for (AccountData data : tmp) {
            if (data instanceof ExtendedAccountData) {
                converted.add((ExtendedAccountData)data);
            } else {
                converted.add(new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
                AltDatabase.getInstance().getAlts().set(index, new ExtendedAccountData(EncryptionTools.decode(data.user), EncryptionTools.decode(data.pass), data.alias));
            }
            ++index;
        }
        return converted;
    }

    private ArrayList<AccountData> getAccountList() {
        return AltDatabase.getInstance().getAlts();
    }

    private ExtendedAccountData getCurrentAsEditable() {
        for (AccountData dat : this.getAccountList()) {
            if (!(dat instanceof ExtendedAccountData) || !dat.equals(this.queriedaccounts.get(this.selectedAccountIndex))) continue;
            return (ExtendedAccountData)dat;
        }
        return null;
    }

    private void updateButtons() {
        this.login.active = !this.queriedaccounts.isEmpty() && !EncryptionTools.decode(this.queriedaccounts.get((int)this.selectedAccountIndex).pass).equals("");
        this.loginoffline.active = !this.queriedaccounts.isEmpty();
        this.delete.active = !this.queriedaccounts.isEmpty();
        this.edit.active = !this.queriedaccounts.isEmpty();
        this.reloadskins.active = !AltDatabase.getInstance().getAlts().isEmpty();
    }

    class List
    extends class_358 {
        public List(class_310 mcIn) {
            super(mcIn, GuiAccountSelector.this.width, GuiAccountSelector.this.height, 32, GuiAccountSelector.this.height - 64, 14);
        }

        protected int getItemCount() {
            return GuiAccountSelector.this.queriedaccounts.size();
        }

        protected boolean isSelectedItem(int i) {
            return i == GuiAccountSelector.this.selectedAccountIndex;
        }

        protected void renderBackground() {
            GuiAccountSelector.this.renderBackground();
        }

        protected void renderItem(int i1, int i2, int i3, int i4, int i5, int i6, float i7) {
            ExtendedAccountData data = (ExtendedAccountData)GuiAccountSelector.this.queriedaccounts.get(i1);
            String s = data.alias;
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = class_1074.method_4662((String)"ias.alt", (Object[])new Object[0]) + " " + (i1 + 1);
            }
            int color = 0xFFFFFF;
            if (class_310.method_1551().method_1548().method_1676().equals(data.alias)) {
                color = 65280;
            }
            GuiAccountSelector.this.drawString(GuiAccountSelector.this.font, s, i2 + 2, i3 + 1, color);
        }

        public int getItemHeight() {
            return GuiAccountSelector.this.queriedaccounts.size() * 14;
        }

        protected boolean selectItem(int i, int i2, double mx, double my) {
            GuiAccountSelector.this.selectedAccountIndex = i;
            GuiAccountSelector.this.updateButtons();
            return super.selectItem(i, i2, mx, my);
        }
    }
}

