/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.iasfork;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4493;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public abstract class ListWidget
extends class_362
implements class_4068 {
    protected static final int NO_DRAG = -1;
    protected static final int DRAG_OUTSIDE = -2;
    protected final class_310 minecraft;
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected final int itemHeight;
    protected boolean centerListVertically = true;
    protected int yDrag = -2;
    protected double scroll;
    protected boolean visible = true;
    protected boolean renderSelection = true;
    protected boolean renderHeader;
    protected int headerHeight;
    private boolean scrolling;

    public ListWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        this.minecraft = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.itemHeight = itemHeight;
        this.left = 0;
        this.right = width;
    }

    public void updateSize(int width, int height, int y, int bottom) {
        this.width = width;
        this.height = height;
        this.top = y;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setRenderSelection(boolean bl) {
        this.renderSelection = bl;
    }

    protected void setRenderHeader(boolean bl, int i) {
        this.renderHeader = bl;
        this.headerHeight = i;
        if (!bl) {
            this.headerHeight = 0;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected abstract int getItemCount();

    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    protected boolean selectItem(int index, int button, double mouseX, double mouseY) {
        return true;
    }

    protected abstract boolean isSelectedItem(int var1);

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected abstract void renderBackground(class_4587 var1);

    protected void updateItemPosition(int index, int i, int j, float f) {
    }

    protected abstract void renderItem(class_4587 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    protected void renderHeader(int i, int j, class_289 tessellator) {
    }

    protected void clickedHeader(int i, int j) {
    }

    protected void renderDecorations(int i, int j) {
    }

    public int getItemAtPosition(double d, double e) {
        int i = this.left + this.width / 2 - this.getRowWidth() / 2;
        int j = this.left + this.width / 2 + this.getRowWidth() / 2;
        int k = class_3532.method_15357((double)(e - (double)this.top)) - this.headerHeight + (int)this.scroll - 4;
        int l = k / this.itemHeight;
        return d < (double)this.getScrollbarPosition() && d >= (double)i && d <= (double)j && l >= 0 && k >= 0 && l < this.getItemCount() ? l : -1;
    }

    protected void capYPosition() {
        this.scroll = class_3532.method_15350((double)this.scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.bottom - this.top - 4));
    }

    public void centerScrollOn(int i) {
        this.scroll = i * this.itemHeight + this.itemHeight / 2 - (this.bottom - this.top) / 2;
        this.capYPosition();
    }

    public int getScroll() {
        return (int)this.scroll;
    }

    public boolean isMouseInList(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom && mouseX >= (double)this.left && mouseX <= (double)this.right;
    }

    public int getScrollBottom() {
        return (int)this.scroll - this.height - this.headerHeight;
    }

    public void scroll(int amount) {
        this.scroll += (double)amount;
        this.capYPosition();
        this.yDrag = -2;
    }

    public void method_25394(class_4587 ms, int mouseX, int mouseY, float delta) {
        if (this.visible) {
            this.renderBackground(ms);
            int i = this.getScrollbarPosition();
            int j = i + 6;
            this.capYPosition();
            class_289 tessellator = class_289.method_1348();
            class_287 bufferBuilder = tessellator.method_1349();
            this.minecraft.method_1531().method_22813(class_332.field_22735);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913((float)this.left / 32.0f, (float)(this.bottom + (int)this.scroll) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913((float)this.right / 32.0f, (float)(this.bottom + (int)this.scroll) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.top, 0.0).method_22913((float)this.right / 32.0f, (float)(this.top + (int)this.scroll) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)this.top, 0.0).method_22913((float)this.left / 32.0f, (float)(this.top + (int)this.scroll) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
            tessellator.method_1350();
            int k = this.left + this.width / 2 - this.getRowWidth() / 2 + 2;
            int l = this.top + 4 - (int)this.scroll;
            if (this.renderHeader) {
                this.renderHeader(k, l, tessellator);
            }
            this.renderList(ms, k, l, mouseX, mouseY, delta);
            RenderSystem.disableDepthTest();
            this.renderHoleBackground(0, this.top, 255, 255);
            this.renderHoleBackground(this.bottom, this.height, 255, 255);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.field_22541, (class_4493.class_4534)class_4493.class_4534.field_22523, (class_4493.class_4535)class_4493.class_4535.field_22544, (class_4493.class_4534)class_4493.class_4534.field_22518);
            RenderSystem.disableAlphaTest();
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableTexture();
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)(this.top + 4), 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)(this.top + 4), 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.top, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)this.top, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            tessellator.method_1350();
            bufferBuilder.method_1328(7, class_290.field_1575);
            bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)this.right, (double)(this.bottom - 4), 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            bufferBuilder.method_22912((double)this.left, (double)(this.bottom - 4), 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            tessellator.method_1350();
            int n = this.getMaxScroll();
            if (n > 0) {
                int o = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
                int p = (int)this.scroll * (this.bottom - this.top - (o = class_3532.method_15340((int)o, (int)32, (int)(this.bottom - this.top - 8)))) / n + this.top;
                if (p < this.top) {
                    p = this.top;
                }
                bufferBuilder.method_1328(7, class_290.field_1575);
                bufferBuilder.method_22912((double)i, (double)this.bottom, 0.0).method_22913(0.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)this.bottom, 0.0).method_22913(1.0f, 1.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)this.top, 0.0).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)this.top, 0.0).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 255).method_1344();
                tessellator.method_1350();
                bufferBuilder.method_1328(7, class_290.field_1575);
                bufferBuilder.method_22912((double)i, (double)(p + o), 0.0).method_22913(0.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)(p + o), 0.0).method_22913(1.0f, 1.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)j, (double)p, 0.0).method_22913(1.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)p, 0.0).method_22913(0.0f, 0.0f).method_1336(128, 128, 128, 255).method_1344();
                tessellator.method_1350();
                bufferBuilder.method_1328(7, class_290.field_1575);
                bufferBuilder.method_22912((double)i, (double)(p + o - 1), 0.0).method_22913(0.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)(j - 1), (double)(p + o - 1), 0.0).method_22913(1.0f, 1.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)(j - 1), (double)p, 0.0).method_22913(1.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                bufferBuilder.method_22912((double)i, (double)p, 0.0).method_22913(0.0f, 0.0f).method_1336(192, 192, 192, 255).method_1344();
                tessellator.method_1350();
            }
            this.renderDecorations(mouseX, mouseY);
            RenderSystem.enableTexture();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    protected void updateScrollingState(double d, double e, int i) {
        this.scrolling = i == 0 && d >= (double)this.getScrollbarPosition() && d < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (this.isVisible() && this.isMouseInList(mouseX, mouseY)) {
            int i = this.getItemAtPosition(mouseX, mouseY);
            if (i == -1 && button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.scroll - 4);
                return true;
            }
            if (i != -1 && this.selectItem(i, button, mouseX, mouseY)) {
                if (this.method_25396().size() > i) {
                    this.method_25395(this.method_25396().get(i));
                }
                this.method_25398(true);
                return true;
            }
            return this.scrolling;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null) {
            this.method_25399().method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.isVisible() && button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.scroll = 0.0;
            } else if (mouseY > (double)this.bottom) {
                this.scroll = this.getMaxScroll();
            } else {
                double d = this.getMaxScroll();
                if (d < 1.0) {
                    d = 1.0;
                }
                int i = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getMaxPosition());
                double e = d / (double)(this.bottom - this.top - (i = class_3532.method_15340((int)i, (int)32, (int)(this.bottom - this.top - 8))));
                if (e < 1.0) {
                    e = 1.0;
                }
                this.scroll += deltaY * e;
                this.capYPosition();
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double d, double e, double amount) {
        if (!this.isVisible()) {
            return false;
        }
        this.scroll -= amount * (double)this.itemHeight / 2.0;
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isVisible()) {
            return false;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 264) {
            this.moveSelection(1);
            return true;
        }
        if (keyCode == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int i) {
    }

    public boolean method_25400(char chr, int keyCode) {
        return !this.isVisible() ? false : super.method_25400(chr, keyCode);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isMouseInList(mouseX, mouseY);
    }

    public int getRowWidth() {
        return 220;
    }

    protected void renderList(class_4587 ms, int x, int y, int mouseX, int mouseY, float f) {
        int i = this.getItemCount();
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        for (int j = 0; j < i; ++j) {
            int k = y + j * this.itemHeight + this.headerHeight;
            int l = this.itemHeight - 4;
            if (k > this.bottom || k + l < this.top) {
                this.updateItemPosition(j, x, k, f);
            }
            if (this.renderSelection && this.isSelectedItem(j)) {
                int m = this.left + this.width / 2 - this.getRowWidth() / 2;
                int n = this.left + this.width / 2 + this.getRowWidth() / 2;
                RenderSystem.disableTexture();
                float g = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)g, (float)g, (float)g, (float)1.0f);
                bufferBuilder.method_1328(7, class_290.field_1592);
                bufferBuilder.method_22912((double)m, (double)(k + l + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)n, (double)(k + l + 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)n, (double)(k - 2), 0.0).method_1344();
                bufferBuilder.method_22912((double)m, (double)(k - 2), 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                bufferBuilder.method_1328(7, class_290.field_1592);
                bufferBuilder.method_22912((double)(m + 1), (double)(k + l + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(n - 1), (double)(k + l + 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(n - 1), (double)(k - 1), 0.0).method_1344();
                bufferBuilder.method_22912((double)(m + 1), (double)(k - 1), 0.0).method_1344();
                tessellator.method_1350();
                RenderSystem.enableTexture();
            }
            this.renderItem(ms, j, x, k, l, mouseX, mouseY, f);
        }
    }

    protected boolean isFocused() {
        return false;
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    protected void renderHoleBackground(int i, int j, int k, int l) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        this.minecraft.method_1531().method_22813(class_332.field_22735);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(7, class_290.field_1575);
        bufferBuilder.method_22912((double)this.left, (double)j, 0.0).method_22913(0.0f, (float)j / 32.0f).method_1336(64, 64, 64, l).method_1344();
        bufferBuilder.method_22912((double)(this.left + this.width), (double)j, 0.0).method_22913((float)this.width / 32.0f, (float)j / 32.0f).method_1336(64, 64, 64, l).method_1344();
        bufferBuilder.method_22912((double)(this.left + this.width), (double)i, 0.0).method_22913((float)this.width / 32.0f, (float)i / 32.0f).method_1336(64, 64, 64, k).method_1344();
        bufferBuilder.method_22912((double)this.left, (double)i, 0.0).method_22913(0.0f, (float)i / 32.0f).method_1336(64, 64, 64, k).method_1344();
        tessellator.method_1350();
    }

    public void setLeftPos(int x) {
        this.left = x;
        this.right = x + this.width;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }
}

