/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.ias.tools;

import com.github.mrebhan.ingameaccountswitcher.tools.alt.AccountData;
import com.github.mrebhan.ingameaccountswitcher.tools.alt.AltDatabase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import the_fireplace.ias.tools.SkinRender;

@Environment(value=EnvType.CLIENT)
public class SkinTools {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final File cachedir = new File(class_310.method_1551().field_1697, "cachedImages/skins/");
    private static final File skinOut = new File(cachedir, "temp.png");

    public static void buildSkin(String name) {
        int[] head;
        BufferedImage skin;
        try {
            skin = ImageIO.read(new File(cachedir, name + ".png"));
        }
        catch (IOException e) {
            if (skinOut.exists()) {
                skinOut.delete();
            }
            return;
        }
        BufferedImage drawing = new BufferedImage(16, 32, 2);
        if (skin.getHeight() == 64) {
            int i;
            head = skin.getRGB(8, 8, 8, 8, null, 0, 8);
            int[] torso = skin.getRGB(20, 20, 8, 12, null, 0, 8);
            int[] larm = skin.getRGB(44, 20, 4, 12, null, 0, 4);
            int[] rarm = skin.getRGB(36, 52, 4, 12, null, 0, 4);
            int[] lleg = skin.getRGB(4, 20, 4, 12, null, 0, 4);
            int[] rleg = skin.getRGB(20, 52, 4, 12, null, 0, 4);
            int[] hat = skin.getRGB(40, 8, 8, 8, null, 0, 8);
            int[] jacket = skin.getRGB(20, 36, 8, 12, null, 0, 8);
            int[] larm2 = skin.getRGB(44, 36, 4, 12, null, 0, 4);
            int[] rarm2 = skin.getRGB(52, 52, 4, 12, null, 0, 4);
            int[] lleg2 = skin.getRGB(4, 36, 4, 12, null, 0, 4);
            int[] rleg2 = skin.getRGB(4, 52, 4, 12, null, 0, 4);
            for (i = 0; i < hat.length; ++i) {
                if (hat[i] != 0) continue;
                hat[i] = head[i];
            }
            for (i = 0; i < jacket.length; ++i) {
                if (jacket[i] != 0) continue;
                jacket[i] = torso[i];
            }
            for (i = 0; i < larm2.length; ++i) {
                if (larm2[i] != 0) continue;
                larm2[i] = larm[i];
            }
            for (i = 0; i < rarm2.length; ++i) {
                if (rarm2[i] != 0) continue;
                rarm2[i] = rarm[i];
            }
            for (i = 0; i < lleg2.length; ++i) {
                if (lleg2[i] != 0) continue;
                lleg2[i] = lleg[i];
            }
            for (i = 0; i < rleg2.length; ++i) {
                if (rleg2[i] != 0) continue;
                rleg2[i] = rleg[i];
            }
            drawing.setRGB(4, 0, 8, 8, hat, 0, 8);
            drawing.setRGB(4, 8, 8, 12, jacket, 0, 8);
            drawing.setRGB(0, 8, 4, 12, larm2, 0, 4);
            drawing.setRGB(12, 8, 4, 12, rarm2, 0, 4);
            drawing.setRGB(4, 20, 4, 12, lleg2, 0, 4);
            drawing.setRGB(8, 20, 4, 12, rleg2, 0, 4);
        } else {
            head = skin.getRGB(8, 8, 8, 8, null, 0, 8);
            int[] torso = skin.getRGB(20, 20, 8, 12, null, 0, 8);
            int[] arm = skin.getRGB(44, 20, 4, 12, null, 0, 4);
            int[] leg = skin.getRGB(4, 20, 4, 12, null, 0, 4);
            int[] hat = skin.getRGB(40, 8, 8, 8, null, 0, 8);
            for (int i = 0; i < hat.length; ++i) {
                if (hat[i] != 0) continue;
                hat[i] = head[i];
            }
            drawing.setRGB(4, 0, 8, 8, hat, 0, 8);
            drawing.setRGB(4, 8, 8, 12, torso, 0, 8);
            drawing.setRGB(0, 8, 4, 12, arm, 0, 4);
            drawing.setRGB(12, 8, 4, 12, arm, 0, 4);
            drawing.setRGB(4, 20, 4, 12, leg, 0, 4);
            drawing.setRGB(8, 20, 4, 12, leg, 0, 4);
        }
        try {
            ImageIO.write((RenderedImage)drawing, "png", skinOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void javDrawSkin(class_4587 ms, int x, int y, int width, int height) {
        if (!skinOut.exists()) {
            return;
        }
        SkinRender r = new SkinRender(class_310.method_1551().method_1531(), skinOut);
        r.drawImage(ms, x, y, width, height);
    }

    public static void cacheSkins(boolean ingame) {
        if (!cachedir.exists() && !cachedir.mkdirs()) {
            System.err.println("unable to load cachedir");
            return;
        }
        for (int i = 0; i < AltDatabase.getInstance().getAlts().size(); ++i) {
            AccountData data = AltDatabase.getInstance().getAlts().get(i);
            if (!ingame) {
                class_310.method_1551().method_22683().method_24286("Minecraft* " + class_155.method_16673().getName() + " (IAS: Updating skin " + data.alias + "...)");
            }
            File file = new File(cachedir, data.alias + ".png");
            try {
                InputStream is = new URL("https://api.mojang.com/users/profiles/minecraft/" + data.alias).openStream();
                InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                String uuid = ((JsonObject)GSON.fromJson((Reader)isr, JsonObject.class)).get("id").getAsString();
                isr.close();
                is.close();
                is = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid).openStream();
                isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                String s = ((JsonObject)GSON.fromJson((Reader)isr, JsonObject.class)).get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                isr.close();
                is.close();
                is = new URL(((JsonObject)GSON.fromJson(new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8), JsonObject.class)).get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString()).openStream();
                if (file.exists()) {
                    file.delete();
                }
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                is.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!ingame) {
            class_310.method_1551().method_24288();
        }
    }
}

