/*
 * Decompiled with CFR 0.152.
 */
package net.darktree.led.util;

import net.darktree.led.util.KeyBuilder;
import net.darktree.led.util.RecipeHelper;
import net.darktree.led.util.RegistryHelper;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public enum DiodeVariant {
    NORMAL("", 15),
    NORMAL_REINFORCED("reinforced_", 14),
    SHADED("shaded_", 3),
    SHADED_REINFORCED("shaded_reinforced_", 3);

    final String prefix;
    final int light;

    private DiodeVariant(String prefix, int light) {
        this.prefix = prefix;
        this.light = light;
    }

    public FabricBlockSettings settings() {
        return RegistryHelper.settings().strength(this.isReinforced() ? 0.8f : 0.4f);
    }

    public int getLightLevel() {
        return this.light;
    }

    public boolean isShaded() {
        return this == SHADED || this == SHADED_REINFORCED;
    }

    public boolean isReinforced() {
        return this == NORMAL_REINFORCED || this == SHADED_REINFORCED;
    }

    public String getName(String name) {
        return this.prefix + name;
    }

    private static String id(String name) {
        return "led:" + name;
    }

    public RecipeDelegate getRecipe(String pattern, String name) {
        if (this == NORMAL) {
            return (item, color) -> {
                KeyBuilder keys = new KeyBuilder().addItem('A', DiodeVariant.id("led")).addItem('B', "minecraft:" + color.method_7792() + "_stained_glass_pane").addItem('C', "minecraft:iron_nugget");
                RecipeHelper.createShaped(new class_1799((class_1935)item), pattern, keys.get());
            };
        }
        if (this == NORMAL_REINFORCED) {
            return (item, color) -> RecipeHelper.createShapeless(new class_1799((class_1935)item), "minecraft:iron_bars", DiodeVariant.id(name + "_" + color.method_7792()));
        }
        if (this == SHADED) {
            return (item, color) -> RecipeHelper.createShapeless(new class_1799((class_1935)item), DiodeVariant.id("shade"), DiodeVariant.id(name + "_" + color.method_7792()));
        }
        if (this == SHADED_REINFORCED) {
            return (item, color) -> RecipeHelper.createShapeless(new class_1799((class_1935)item), DiodeVariant.id("shade"), "minecraft:iron_bars", DiodeVariant.id(name + "_" + color.method_7792()));
        }
        return null;
    }

    public static RecipeDelegate getButtonRecipe(boolean button) {
        if (button) {
            return (item, color) -> RecipeHelper.createShapeless(new class_1799((class_1935)item, 4), DiodeVariant.id("clear_full_" + color.method_7792()));
        }
        return (item, color) -> RecipeHelper.createShapeless(new class_1799((class_1935)item), "minecraft:lever", DiodeVariant.id("button_" + color.method_7792()));
    }

    public static interface RecipeDelegate {
        public void register(class_1792 var1, class_1767 var2);
    }
}

