/*
 * Decompiled with CFR 0.152.
 */
package net.darktree.led.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class RecipeHelper {
    private static final ArrayList<JsonObject> recipes = new ArrayList();

    public static void createShaped(class_1799 stack, String pattern, JsonObject keys) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        json.add("result", (JsonElement)RecipeHelper.getRecipeResult(stack));
        json.add("pattern", (JsonElement)RecipeHelper.getPattern(pattern));
        json.add("key", (JsonElement)keys);
        recipes.add(json);
    }

    public static void createShapeless(class_1799 stack, String ... items) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        json.add("result", (JsonElement)RecipeHelper.getRecipeResult(stack));
        JsonArray ingredients = new JsonArray();
        for (String item : items) {
            JsonObject ingredient = new JsonObject();
            ingredient.addProperty("item", item);
            ingredients.add((JsonElement)ingredient);
        }
        json.add("ingredients", (JsonElement)ingredients);
        recipes.add(json);
    }

    private static JsonObject getRecipeResult(class_1799 stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", RecipeHelper.getIdentifier(stack.method_7909()));
        json.addProperty("count", (Number)stack.method_7947());
        return json;
    }

    private static JsonArray getPattern(String pattern) {
        String[] lines;
        JsonArray jsonArray = new JsonArray();
        for (String line : lines = pattern.split(",")) {
            jsonArray.add(line);
        }
        return jsonArray;
    }

    private static String getIdentifier(class_1792 item) {
        return class_2378.field_11142.method_10221((Object)item).toString();
    }

    public static void register(Map<class_2960, JsonElement> map) {
        for (JsonObject recipe : recipes) {
            class_2960 id = new class_2960(recipe.getAsJsonObject("result").getAsJsonPrimitive("item").getAsString());
            map.put(id, (JsonElement)recipe);
        }
    }
}

