/*
 * Decompiled with CFR 0.152.
 */
package net.darktree.led.util;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.darktree.led.LED;
import net.darktree.led.util.ClientDelegate;
import net.darktree.led.util.DiodeVariant;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3614;

public class RegistryHelper {
    private static final ArrayList<ClientDelegate> delegates = new ArrayList();
    public static final String ID = "led";
    public static final class_1761 GROUP = FabricItemGroupBuilder.create((class_2960)RegistryHelper.id("group")).icon(() -> new class_1799((class_1935)LED.BULB)).build();
    public static final FabricItemSettings ITEM_SETTINGS = new FabricItemSettings().group(GROUP);

    public static FabricBlockSettings settings() {
        return FabricBlockSettings.of((class_3614)class_3614.field_15953).breakByHand(true).strength(0.4f);
    }

    public static class_2960 id(String name) {
        return new class_2960(ID, name);
    }

    public static void registerForColors(String name, Supplier<class_2248> supplier, DiodeVariant.RecipeDelegate recipe) {
        for (class_1767 color : class_1767.values()) {
            class_2248 block = supplier.get();
            class_1747 item = new class_1747(block, (class_1792.class_1793)ITEM_SETTINGS);
            String suffix = "_" + color.method_7792();
            ClientDelegate delegate = new ClientDelegate(color);
            delegate.setBlock(block);
            delegate.setItem((class_1792)item);
            RegistryHelper.registerItem(name + suffix, (class_1792)item);
            RegistryHelper.registerBlock(name + suffix, block);
            recipe.register((class_1792)item, color);
            delegates.add(delegate);
        }
    }

    public static void registerItem(String name, class_1792 item) {
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)RegistryHelper.id(name), (Object)item);
    }

    public static void registerBlock(String name, class_2248 block) {
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)RegistryHelper.id(name), (Object)block);
    }

    @Environment(value=EnvType.CLIENT)
    public static void applyDelegates() {
        for (ClientDelegate delegate : delegates) {
            delegate.register();
        }
        LED.LOG.info("[LED] Applied " + delegates.size() + " client delegates.");
        delegates.clear();
    }

    @Environment(value=EnvType.SERVER)
    public static void discardDelegates() {
        LED.LOG.info("[LED] Discarded " + delegates.size() + " client delegates.");
        delegates.clear();
    }
}

