/*
 * Decompiled with CFR 0.152.
 */
package de.luckycrew.halloween.entity;

import de.luckycrew.halloween.network.HalloweenNetwork;
import de.luckycrew.halloween.network.message.MessageGhostFlash;
import de.luckycrew.halloween.sound.HalloweenSounds;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityGhost
extends EntityFlying
implements IMob {
    public EntityGhost(World world) {
        super(world);
        this.func_70105_a(1.5f, 1.5f);
        this.field_70728_aV = 12;
        this.field_70765_h = new GhostMoveHelper();
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIRandomFly());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AILookAround());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIAttack());
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public String func_70639_aQ() {
        return HalloweenSounds.snivelling;
    }

    public String func_70621_aR() {
        return HalloweenSounds.strange_laughing;
    }

    public String func_70673_aS() {
        return HalloweenSounds.thunder;
    }

    public Item func_146068_u() {
        return Items.field_151016_H;
    }

    public float func_70599_aP() {
        return 2.0f;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 2;
    }

    public float func_70047_e() {
        return 1.6f;
    }

    class GhostMoveHelper
    extends EntityMoveHelper {
        private final double speed = 0.25;
        private EntityGhost ghost;
        private int i;

        public GhostMoveHelper() {
            super((EntityLiving)EntityGhost.this);
            this.speed = 0.25;
            this.ghost = EntityGhost.this;
        }

        public void func_75641_c() {
            if (this.field_75643_f) {
                double d0 = this.field_75646_b - this.ghost.field_70165_t;
                double d1 = this.field_75647_c - this.ghost.field_70163_u;
                double d2 = this.field_75644_d - this.ghost.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.i-- <= 0) {
                    this.i += this.ghost.func_70681_au().nextInt(5) + 2;
                    if (this.calculate(this.field_75646_b, this.field_75647_c, this.field_75644_d, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                        this.ghost.field_70159_w += d0 / d3 * 0.25;
                        this.ghost.field_70181_x += d1 / d3 * 0.25;
                        this.ghost.field_70179_y += d2 / d3 * 0.25;
                    } else {
                        this.field_75643_f = false;
                    }
                }
            }
        }

        private boolean calculate(double x, double y, double z, double d) {
            double d4 = (x - this.ghost.field_70165_t) / d;
            double d5 = (y - this.ghost.field_70163_u) / d;
            double d6 = (z - this.ghost.field_70161_v) / d;
            AxisAlignedBB axisalignedbb = this.ghost.func_174813_aQ();
            int i = 1;
            while ((double)i < d) {
                if (!this.ghost.field_70170_p.func_72945_a((Entity)this.ghost, axisalignedbb = axisalignedbb.func_72317_d(d4, d5, d6)).isEmpty()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    class AIRandomFly
    extends EntityAIBase {
        private EntityGhost ghost;

        public AIRandomFly() {
            this.ghost = EntityGhost.this;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            double d2;
            double d1;
            EntityMoveHelper entitymovehelper = this.ghost.func_70605_aq();
            if (!entitymovehelper.func_75640_a()) {
                return true;
            }
            double d0 = entitymovehelper.func_179917_d() - this.ghost.field_70165_t;
            double d3 = d0 * d0 + (d1 = entitymovehelper.func_179919_e() - this.ghost.field_70163_u) * d1 + (d2 = entitymovehelper.func_179918_f() - this.ghost.field_70161_v) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random random = this.ghost.func_70681_au();
            double d0 = this.ghost.field_70165_t + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghost.field_70163_u + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.ghost.field_70161_v + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.ghost.func_70605_aq().func_75642_a(d0, d1, d2, 1.0);
        }
    }

    class AILookAround
    extends EntityAIBase {
        private EntityGhost ghost;

        public AILookAround() {
            this.ghost = EntityGhost.this;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.ghost.func_70638_az() == null) {
                this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)Math.atan2(this.ghost.field_70159_w, this.ghost.field_70179_y)) * 180.0f / (float)Math.PI;
            } else {
                EntityLivingBase entitylivingbase = this.ghost.func_70638_az();
                double d0 = 64.0;
                if (entitylivingbase.func_70068_e((Entity)this.ghost) < d0 * d0) {
                    double d1 = entitylivingbase.field_70165_t - this.ghost.field_70165_t;
                    double d2 = entitylivingbase.field_70161_v - this.ghost.field_70161_v;
                    this.ghost.field_70761_aq = this.ghost.field_70177_z = -((float)Math.atan2(d1, d2)) * 180.0f / (float)Math.PI;
                }
            }
        }
    }

    class AIAttack
    extends EntityAIBase {
        private EntityGhost ghost;
        public int ticks;

        AIAttack() {
            this.ghost = EntityGhost.this;
        }

        public boolean func_75250_a() {
            return this.ghost.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.ticks = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.ghost.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.ghost) < d0 * d0 && this.ghost.func_70685_l((Entity)entitylivingbase)) {
                World world = this.ghost.field_70170_p;
                ++this.ticks;
                if (this.ticks == 90) {
                    world.func_72956_a((Entity)entitylivingbase, HalloweenSounds.ringle, 1.0f, world.field_73012_v.nextFloat() * 0.8f + 0.6f);
                    entitylivingbase.func_70097_a(DamageSource.field_76376_m, 4.0f);
                    if (!world.field_72995_K && entitylivingbase instanceof EntityPlayerMP) {
                        HalloweenNetwork.network.sendTo((IMessage)new MessageGhostFlash(), (EntityPlayerMP)entitylivingbase);
                    }
                    this.ticks = -10;
                }
            } else if (this.ticks > 0) {
                --this.ticks;
            }
        }
    }
}

