/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.util;

import com.maideniles.maidensmaterials.init.blocks.base.BlockFinishingsBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockStateHandler {
    public static Block getBlock(IBlockAccess world, BlockPos pos, EnumFacing facing, Direction dir) {
        BlockPos target = BlockStateHandler.getBlockPosRelativeTo(world, pos, facing, dir);
        return world.func_180495_p(target).func_177230_c();
    }

    public static Direction getRotation(IBlockAccess world, BlockPos pos, EnumFacing facing, Direction dir) {
        BlockPos target = BlockStateHandler.getBlockPosRelativeTo(world, pos, facing, dir);
        EnumFacing other = (EnumFacing)world.func_180495_p(target).func_177229_b((IProperty)BlockFinishingsBase.FACING);
        Direction dir_2 = BlockStateHandler.getDirectionRelativeTo(facing, other);
        return dir_2;
    }

    public static boolean isAirBlock(IBlockAccess world, BlockPos pos, EnumFacing facing, Direction dir) {
        BlockPos target = BlockStateHandler.getBlockPosRelativeTo(world, pos, facing, dir);
        return world.func_180495_p(target).func_177230_c() instanceof BlockAir;
    }

    private static BlockPos getBlockPosRelativeTo(IBlockAccess world, BlockPos pos, EnumFacing facing, Direction dir) {
        switch (dir) {
            case LEFT: {
                return pos.func_177972_a(facing.func_176746_e());
            }
            case RIGHT: {
                return pos.func_177972_a(facing.func_176735_f());
            }
            case UP: {
                return pos.func_177972_a(facing);
            }
            case DOWN: {
                return pos.func_177972_a(facing.func_176734_d());
            }
        }
        return pos;
    }

    private static Direction getDirectionRelativeTo(EnumFacing thisBlock, EnumFacing otherBlock) {
        int num = thisBlock.func_176736_b() - otherBlock.func_176736_b();
        switch (num) {
            case -3: {
                return Direction.LEFT;
            }
            case -2: {
                return Direction.UP;
            }
            case -1: {
                return Direction.RIGHT;
            }
            case 0: {
                return Direction.DOWN;
            }
            case 1: {
                return Direction.LEFT;
            }
            case 2: {
                return Direction.UP;
            }
            case 3: {
                return Direction.RIGHT;
            }
        }
        return Direction.NONE;
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

