/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.biome;

import com.maideniles.maidensmaterials.config.ConfigHandler;
import com.maideniles.maidensmaterials.init.MaidensBlocks;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenCedarTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenCrabappleTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenCrabappleTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenDogwoodTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenDogwoodTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenJacarandaTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenJacarandaTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenLaburnumTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenLaburnumTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenPaulowniaTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenPaulowniaTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenSilverBellTreeTallVines;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenSilverbellTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenWisteriaTree;
import com.maideniles.maidensmaterials.world.feature.tree.WorldGenWisteriaTreeTallVines;
import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeOrnamentalForest
extends Biome {
    private int WaterColorMultiplier;

    public BiomeOrnamentalForest() {
        super(new Biome.BiomeProperties("ornamental_forest").func_185398_c(0.125f).func_185400_d(0.01f).func_185410_a(0.7f).func_185395_b(0.8f).func_185402_a(65535));
        this.field_76752_A = MaidensBlocks.ornamental_grass.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        this.field_76760_I.field_76832_z = -1;
        this.field_76760_I.field_76803_B = 2;
        this.field_76760_I.field_76802_A = 60;
        this.field_76760_I.field_76798_D = 70;
        this.field_76760_I.field_76807_J = 2;
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 10, 1, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityParrot.class, 10, 1, 5));
        this.addDefaultFlowers();
        this.WaterColorMultiplier = 0xFFFFFF;
        this.flowers.clear();
        for (BlockFlower.EnumFlowerType type : BlockFlower.EnumFlowerType.values()) {
            if (type.func_176964_a() == BlockFlower.EnumFlowerColor.YELLOW) continue;
            if (type == BlockFlower.EnumFlowerType.BLUE_ORCHID) {
                type = BlockFlower.EnumFlowerType.BLUE_ORCHID;
            }
            this.addFlower(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)type), 10);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 108855;
    }

    public int func_180625_c(BlockPos pos) {
        return 108855;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        double d0 = MathHelper.func_151237_a((double)((1.0 + field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        BlockFlower.EnumFlowerType blockflower$enumflowertype = BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
        return blockflower$enumflowertype == BlockFlower.EnumFlowerType.BLUE_ORCHID ? BlockFlower.EnumFlowerType.BLUE_ORCHID : blockflower$enumflowertype;
    }

    public void addDoublePlants(World p_185378_1_, Random p_185378_2_, BlockPos p_185378_3_, int p_185378_4_) {
        block0: for (int i = 0; i < p_185378_4_; ++i) {
            int j = p_185378_2_.nextInt(3);
            if (j == 0) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
            } else if (j == 1) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.ROSE);
            } else if (j == 2) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.PAEONIA);
            }
            for (int k = 0; k < 5; ++k) {
                int l = p_185378_2_.nextInt(16) + 8;
                int i1 = p_185378_2_.nextInt(16) + 8;
                int j1 = p_185378_2_.nextInt(p_185378_1_.func_175645_m(p_185378_3_.func_177982_a(l, 0, i1)).func_177956_o() + 32);
                if (field_180280_ag.func_180709_b(p_185378_1_, p_185378_2_, new BlockPos(p_185378_3_.func_177958_n() + l, j1, p_185378_3_.func_177952_p() + i1))) continue block0;
            }
        }
    }

    public void addCedarTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + p_185379_2_.nextInt(3);
                int l = j * 4 + 1 + 8 + p_185379_2_.nextInt(3);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenCedarTree CEDAR = new WorldGenCedarTree(true, true);
                CEDAR.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addCrabappleTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + p_185379_2_.nextInt(2);
                int l = j * 4 + 1 + 8 + p_185379_2_.nextInt(2);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenCrabappleTree CRABAPPLE = new WorldGenCrabappleTree(true, true);
                WorldGenCrabappleTreeTallVines CRABAPPLE_VINES = new WorldGenCrabappleTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_CRABAPPLE_WITH_VINES) {
                    CRABAPPLE_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                CRABAPPLE.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addDogwoodTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + p_185379_2_.nextInt(5);
                int l = j * 4 + 1 + 8 + p_185379_2_.nextInt(5);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenDogwoodTree DOGWOOD = new WorldGenDogwoodTree(true, true);
                WorldGenDogwoodTreeTallVines DOGWOOD_VINES = new WorldGenDogwoodTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_DOGWOOD_WITH_VINES) {
                    DOGWOOD_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                DOGWOOD.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addJacarandaTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 1 + 8 + p_185379_2_.nextInt(4);
                int l = j * 4 + 1 + 8 + p_185379_2_.nextInt(4);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenJacarandaTree JACARANDA = new WorldGenJacarandaTree(true, true);
                WorldGenJacarandaTreeTallVines JACARANDA_VINES = new WorldGenJacarandaTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_JACARANDA_WITH_VINES) {
                    JACARANDA_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                JACARANDA.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addLaburnumTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 3 + 8 + p_185379_2_.nextInt(3);
                int l = j * 4 + 3 + 8 + p_185379_2_.nextInt(3);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenLaburnumTree LABURNUM = new WorldGenLaburnumTree(true, true);
                WorldGenLaburnumTreeTallVines LABURNUM_VINES = new WorldGenLaburnumTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_LABURNUM_WITH_VINES) {
                    LABURNUM_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                LABURNUM.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addPaulowniaTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 2 + 8 + p_185379_2_.nextInt(5);
                int l = j * 4 + 2 + 8 + p_185379_2_.nextInt(5);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenPaulowniaTree PAULOWNIA = new WorldGenPaulowniaTree(true, true);
                WorldGenPaulowniaTreeTallVines PAULOWNIA_VINES = new WorldGenPaulowniaTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_PAULOWNIA_WITH_VINES) {
                    PAULOWNIA_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                PAULOWNIA.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addSilverbellTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 3 + 8 + p_185379_2_.nextInt(2);
                int l = j * 4 + 3 + 8 + p_185379_2_.nextInt(2);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenSilverbellTree SILVERBELL = new WorldGenSilverbellTree(true, true);
                WorldGenSilverBellTreeTallVines SILVERBELL_VINES = new WorldGenSilverBellTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_SILVERBELL_WITH_VINES) {
                    SILVERBELL_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                SILVERBELL.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void addWisteriaTrees(World p_185379_1_, Random p_185379_2_, BlockPos p_185379_3_) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int k = i * 4 + 2 + 8 + p_185379_2_.nextInt(1);
                int l = j * 4 + 2 + 8 + p_185379_2_.nextInt(1);
                BlockPos blockpos = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, 0, l));
                BlockPos blockpos2 = p_185379_1_.func_175645_m(p_185379_3_.func_177982_a(k, -2, l));
                if (p_185379_2_.nextInt(1) != 0 || !TerrainGen.decorate((World)p_185379_1_, (Random)p_185379_2_, (BlockPos)blockpos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) continue;
                WorldGenWisteriaTree WISTERIA = new WorldGenWisteriaTree(true, true);
                WorldGenWisteriaTreeTallVines WISTERIA_VINES = new WorldGenWisteriaTreeTallVines(true);
                if (ConfigHandler.FOREST_SPAWN_WISTERIA_WITH_VINES) {
                    WISTERIA_VINES.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
                    continue;
                }
                WISTERIA.func_180709_b(p_185379_1_, p_185379_2_, blockpos);
            }
        }
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            int i = rand.nextInt(5) - 3;
            this.addDoublePlants(worldIn, rand, pos, i);
            this.addCedarTrees(worldIn, rand, pos);
            this.addCrabappleTrees(worldIn, rand, pos);
            this.addDogwoodTrees(worldIn, rand, pos);
            this.addJacarandaTrees(worldIn, rand, pos);
            this.addLaburnumTrees(worldIn, rand, pos);
            this.addPaulowniaTrees(worldIn, rand, pos);
            this.addSilverbellTrees(worldIn, rand, pos);
            this.addWisteriaTrees(worldIn, rand, pos);
        }
        super.func_180624_a(worldIn, rand, pos);
    }
}

