/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials;

import com.maideniles.maidensmaterials.client.RenderLayers;
import com.maideniles.maidensmaterials.config.Config;
import com.maideniles.maidensmaterials.init.BiomeInit;
import com.maideniles.maidensmaterials.init.ModBlocks;
import com.maideniles.maidensmaterials.init.ModEnchantments;
import com.maideniles.maidensmaterials.init.ModFeatures;
import com.maideniles.maidensmaterials.init.ModItems;
import com.maideniles.maidensmaterials.potion.MaidensPotions;
import com.maideniles.maidensmaterials.util.CompostingUtil;
import com.maideniles.maidensmaterials.world.gen.OreGen;
import com.maideniles.maidensmaterials.world.gen.decorator.tree.MaidensTreeDecoratorTypes;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="maidensmaterials")
@Mod.EventBusSubscriber(modid="maidensmaterials", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class MarvelousMaterials {
    public static MarvelousMaterials instance;
    public static final String MODID = "maidensmaterials";
    public static final Logger LOGGER;

    public MarvelousMaterials() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        ModEnchantments.ENCHANTMENTS.register(modEventBus);
        LOGGER.debug("Hello from Maiden's Materials!");
        MaidensPotions.EFFECTS.register(modEventBus);
        LOGGER.debug("Effects Registered!");
        MaidensPotions.POTIONS.register(modEventBus);
        LOGGER.debug("Potions Registered!");
        ModBlocks.BLOCKS.register(modEventBus);
        LOGGER.debug("Blocks Registered!");
        ModItems.ITEMS.register(modEventBus);
        LOGGER.debug("Items Registered!");
        BiomeInit.BIOMES.register(modEventBus);
        LOGGER.debug("Biomes Registered!");
        instance = this;
        Config.loadConfig(Config.CLIENT, FMLPaths.CONFIGDIR.get().resolve("maidensmaterials-client.toml").toString());
        Config.loadConfig(Config.SERVER, FMLPaths.CONFIGDIR.get().resolve("maidensmaterials-server.toml").toString());
        LOGGER.debug("Config Loaded!");
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> RenderLayers::safeRunClient);
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        BiomeInit.registerBiomes();
    }

    @SubscribeEvent
    public static void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.registerFeatures(event.getRegistry());
    }

    @SubscribeEvent
    public void registerTreeDecoratorTypes(RegistryEvent.Register<TreeDecoratorType<?>> event) {
        event.getRegistry().register(MaidensTreeDecoratorTypes.MAIDENS_TRUNK_VINE.setRegistryName("maidens_trunk_vine_decorator"));
        event.getRegistry().register(MaidensTreeDecoratorTypes.MAIDENS_LEAF_VINE.setRegistryName("maidens_leaf_vine_decorator"));
        event.getRegistry().register(MaidensTreeDecoratorTypes.MAIDENS_MUSHROOM.setRegistryName("maidens_mushroom_decorator"));
    }

    public void setup(FMLCommonSetupEvent event) {
        OreGen.setupOreGen();
        CompostingUtil.setup();
        LOGGER.debug("Oregen Registered!");
        ModBlocks.registerFlammables();
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
    }
}

