/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.potion;

import com.maideniles.maidensmaterials.init.ModItems;
import com.maideniles.maidensmaterials.potion.FloralFortuneEffect;
import com.maideniles.maidensmaterials.potion.GatherersGleeEffect;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="maidensmaterials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MaidensPotions {
    public static final DeferredRegister<Effect> EFFECTS = new DeferredRegister(ForgeRegistries.POTIONS, "maidensmaterials");
    public static final DeferredRegister<Potion> POTIONS = new DeferredRegister(ForgeRegistries.POTION_TYPES, "maidensmaterials");
    public static final RegistryObject<Effect> FLORAL_FORTUNE_EFFECT = EFFECTS.register("floral_fortune", FloralFortuneEffect::new);
    public static final RegistryObject<Effect> GATHERERS_GLEE_EFFECT = EFFECTS.register("gatherers_glee", GatherersGleeEffect::new);
    public static final RegistryObject<Potion> FLORAL_FORTUNE_POTION = POTIONS.register("floral_fortune", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)FLORAL_FORTUNE_EFFECT.get(), 900, 0)}));
    public static final RegistryObject<Potion> GATHERERS_GLEE_POTION = POTIONS.register("gatherers_glee", () -> new Potion(new EffectInstance[]{new EffectInstance((Effect)GATHERERS_GLEE_EFFECT.get(), 900, 0)}));

    public static void addPotionRecipes() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.field_185231_c, (Item)ModItems.FLORAL_ESSENCE.get(), (Potion)FLORAL_FORTUNE_POTION.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.field_185231_c, (Item)ModItems.EARTHEN_ESSENCE.get(), (Potion)GATHERERS_GLEE_POTION.get()));
    }

    private static class BetterBrewingRecipe
    implements IBrewingRecipe {
        private final Potion bottleInput;
        private final Item itemInput;
        private final ItemStack output;

        public BetterBrewingRecipe(Potion bottleInputIn, Item itemInputIn, Potion outputIn) {
            this.bottleInput = bottleInputIn;
            this.itemInput = itemInputIn;
            this.output = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)outputIn);
        }

        public boolean isInput(ItemStack input) {
            return PotionUtils.func_185191_c((ItemStack)input).equals(this.bottleInput);
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.func_77973_b().equals(this.itemInput);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (this.isInput(input) && this.isIngredient(ingredient)) {
                return this.output.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }
    }
}

