/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.feature.tree;

import com.google.common.collect.ImmutableList;
import com.maideniles.maidensmaterials.world.gen.decorator.tree.leaf.MaidenLeavesVineTreeDecorator;
import com.maideniles.maidensmaterials.world.gen.decorator.tree.mushroom.MushroomTreeDecorator;
import com.maideniles.maidensmaterials.world.gen.decorator.tree.trunk.MaidenTrunkVineTreeDecorator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.ConfiguredRandomFeatureList;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.BeehiveTreeDecorator;
import net.minecraftforge.common.IPlantable;

public class MaidensTreeCategory {
    public final ConfiguredFeature<TreeFeatureConfig, ?> mushrooms;
    public final ConfiguredFeature<TreeFeatureConfig, ?> base;
    public final ConfiguredFeature<TreeFeatureConfig, ?> vines;
    public final ConfiguredFeature<?, ?> worldgen;

    public MaidensTreeCategory(Feature<TreeFeatureConfig> feature, BlockState trunk, BlockState leaves, int baseHeight, int maxHeight, float treesPerChunk, boolean vinesInWorldgen, IPlantable sapling) {
        TreeFeatureConfig.Builder configBuilder = new TreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(trunk), (BlockStateProvider)new SimpleBlockStateProvider(leaves), (FoliagePlacer)new BlobFoliagePlacer(2, 0)).func_225569_d_(baseHeight).func_227354_b_(maxHeight - baseHeight).func_227360_i_(3).func_227352_a_().func_227353_a_((List)ImmutableList.of((Object)new BeehiveTreeDecorator(0.01f))).setSapling(sapling);
        this.base = feature.func_225566_b_((IFeatureConfig)configBuilder.func_225568_b_());
        this.vines = feature.func_225566_b_((IFeatureConfig)configBuilder.func_227353_a_((List)ImmutableList.of((Object)((Object)new MushroomTreeDecorator(0.25f)), (Object)new BeehiveTreeDecorator(0.01f), (Object)((Object)new MaidenTrunkVineTreeDecorator()), (Object)((Object)new MaidenLeavesVineTreeDecorator()))).func_225568_b_());
        int baseTreesPerChunk = MathHelper.func_76141_d((float)treesPerChunk);
        this.mushrooms = feature.func_225566_b_((IFeatureConfig)configBuilder.func_227353_a_((List)ImmutableList.of((Object)((Object)new MushroomTreeDecorator(0.25f)))).func_225568_b_());
        this.worldgen = (vinesInWorldgen ? Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)new ConfiguredRandomFeatureList(this.vines, 0.5f)), this.base)) : this.base).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(baseTreesPerChunk, treesPerChunk - (float)baseTreesPerChunk, 1)));
    }
}

