/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.feature.tree;

import com.maideniles.maidensmaterials.init.ModBlocks;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class MaidensTreeFeature
extends TreeFeature {
    private final Block extraSoil;

    public MaidensTreeFeature() {
        this((Block)ModBlocks.ornamentalGrass.get());
    }

    protected MaidensTreeFeature(Block extraSoil) {
        super(TreeFeatureConfig::func_227338_a_);
        this.extraSoil = extraSoil;
    }

    public Optional<BlockPos> func_227212_a_(IWorldGenerationReader world, int height, int trunkHeight, int foliage, BlockPos pos, TreeFeatureConfig config) {
        BlockPos blockpos;
        if (!config.field_227372_q_) {
            int oceanFloorHeight = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int surfaceHeight = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            blockpos = new BlockPos(pos.func_177958_n(), oceanFloorHeight, pos.func_177952_p());
            if (surfaceHeight - oceanFloorHeight > config.field_227336_k_) {
                return Optional.empty();
            }
        } else {
            blockpos = pos;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + height + 1 <= world.getMaxHeight()) {
            for (int yOffset = 0; yOffset <= height + 1; ++yOffset) {
                int width = config.field_227327_a_.func_225570_a_(trunkHeight, height, foliage, yOffset);
                BlockPos.Mutable mutablePos = new BlockPos.Mutable();
                for (int xOffset = -width; xOffset <= width; ++xOffset) {
                    for (int zOffset = -width; zOffset <= width; ++zOffset) {
                        if (yOffset + blockpos.func_177956_o() >= 0 && yOffset + blockpos.func_177956_o() < world.getMaxHeight()) {
                            mutablePos.func_181079_c(xOffset + blockpos.func_177958_n(), yOffset + blockpos.func_177956_o(), zOffset + blockpos.func_177952_p());
                            if (MaidensTreeFeature.func_214587_a((IWorldGenerationBaseReader)world, (BlockPos)mutablePos) && (config.field_227337_l_ || !MaidensTreeFeature.func_227222_d_((IWorldGenerationBaseReader)world, (BlockPos)mutablePos))) {
                                continue;
                            }
                            return Optional.empty();
                        }
                        return Optional.empty();
                    }
                }
            }
            boolean soil = this.isMaidenSoil(world, blockpos.func_177977_b(), config.getSapling());
            return soil && blockpos.func_177956_o() < world.getMaxHeight() - height - 1 ? Optional.of(blockpos) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean isMaidenSoil(IWorldGenerationReader world, BlockPos soilPos, IPlantable sapling) {
        return MaidensTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)world, (BlockPos)soilPos, (IPlantable)sapling) || world.func_217375_a(soilPos, state -> state.func_177230_c() == this.extraSoil);
    }
}

