/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.feature.tree;

import com.maideniles.maidensmaterials.init.ModBlocks;
import com.maideniles.maidensmaterials.world.feature.tree.MaidensTreeFeature;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CocoaBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class PalmTreeFeature
extends MaidensTreeFeature {
    public PalmTreeFeature() {
        super((Block)ModBlocks.sparklingSand.get());
    }

    public boolean func_225557_a_(IWorldGenerationReader world, Random rand, BlockPos pos, Set<BlockPos> logs, Set<BlockPos> leaves, MutableBoundingBox box, TreeFeatureConfig config) {
        int height = config.field_227371_p_ + rand.nextInt(config.field_227328_b_);
        int i = rand.nextInt(3) + 10;
        if (!this.ensureGrowable(world, pos, height, config)) {
            return false;
        }
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        int xPos = pos.func_177958_n();
        int zPos = pos.func_177952_p();
        int top = 0;
        for (int block = 0; block <= height; ++block) {
            BlockPos blockpos;
            int yPos = pos.func_177956_o() + block;
            if (yPos > pos.func_177956_o() && yPos <= pos.func_177956_o() + (height - 3) && rand.nextInt(10) == 1) {
                xPos += direction.func_82601_c();
                zPos += direction.func_82599_e();
            }
            if (!PalmTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)(blockpos = new BlockPos(xPos, yPos, zPos)))) continue;
            this.placeLogAt(logs, world, blockpos, box, rand, config);
            top = yPos;
        }
        BlockPos topBlock = new BlockPos(xPos, top, zPos);
        this.placeLeafAt(leaves, world, topBlock.func_177982_a(0, 1, 0), box, rand, config);
        for (Direction side : Direction.Plane.HORIZONTAL) {
            this.leafLayer1(logs, leaves, world, topBlock, rand, side, box, config);
        }
        return true;
    }

    private void leafLayer1(Set<BlockPos> logs, Set<BlockPos> leaves, IWorldGenerationReader worldIn, BlockPos pos, Random random, Direction side, MutableBoundingBox box, TreeFeatureConfig config) {
        int k = -5;
        int i = -4;
        int j = -6;
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 8, k + 5), ((Block)ModBlocks.palmLog.get()).func_176223_P());
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 6, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 6, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 7, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 7, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 8, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 1, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 2, j + 8, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 2, j + 8, k + 7), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 2, j + 9, k + 3), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 2, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 7, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 7, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 8, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 8, k + 5), config.field_227368_m_, config, logs, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 8, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 9, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 9, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 10, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 3, j + 10, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 5, k + 0), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 5, k + 10), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 6, k + 0), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 6, k + 10), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 7, k + 1), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 7, k + 5), config.field_227368_m_, config, logs, box, random);
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 3, j + 7, k + 5), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 4), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 5, j + 7, k + 5), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        if (random.nextInt(10) == 0) {
            this.func_202278_a((IWorldWriter)worldIn, pos.func_177982_a(i + 4, j + 7, k + 6), ((Block)ModBlocks.coconutNut.get()).func_176223_P());
        }
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 7, k + 9), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 1), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 3), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 4), config.field_227368_m_, config, logs, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 5), config.field_227368_m_, config, logs, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 6), config.field_227368_m_, config, logs, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 7), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 8, k + 9), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 3), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 7), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 9, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 4, j + 10, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 7, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 7, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 8, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 8, k + 5), config.field_227368_m_, config, logs, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 8, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 9, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 9, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 10, k + 4), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 5, j + 10, k + 6), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 6, j + 8, k + 3), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 6, j + 8, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 6, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 6, j + 9, k + 7), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 6, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 6, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 7, k + 2), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 7, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 8, k + 8), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 7, j + 9, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 8, j + 7, k + 5), config.field_227369_n_, config, leaves, box, random);
        this.setBlockState(worldIn, pos.func_177982_a(i + 8, j + 8, k + 5), config.field_227369_n_, config, leaves, box, random);
    }

    private void setBlockState(IWorldGenerationReader world, BlockPos pos, BlockStateProvider stateProvider, TreeFeatureConfig config, Set<BlockPos> changedBlocks, MutableBoundingBox box, Random rand) {
        if (stateProvider == config.field_227369_n_) {
            this.placeLeafAt(changedBlocks, world, pos, box, rand, config);
        } else {
            this.placeLogAt(changedBlocks, world, pos, box, rand, config);
        }
    }

    private void placeLogAt(Set<BlockPos> logs, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox box, Random rand, TreeFeatureConfig config) {
        this.func_227216_a_(world, rand, pos, logs, box, (BaseTreeFeatureConfig)config);
    }

    private void placeLeafAt(Set<BlockPos> leaves, IWorldGenerationReader world, BlockPos pos, MutableBoundingBox box, Random rand, TreeFeatureConfig config) {
        if (PalmTreeFeature.func_214572_g((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.func_227219_b_(world, rand, pos, leaves, box, (BaseTreeFeatureConfig)config);
        }
    }

    protected boolean ensureGrowable(IWorldGenerationReader worldIn, BlockPos treePos, int height, TreeFeatureConfig config) {
        return this.isSpaceAt(worldIn, treePos, height) && this.ensureViableBlockUnderneath(treePos, worldIn, config);
    }

    private boolean isSpaceAt(IWorldGenerationReader worldIn, BlockPos pos, int height) {
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y >= 1 && y + height + 1 <= 256) {
            for (int yPos = y; yPos <= y + 1 + height; ++yPos) {
                int b0 = 1;
                if (yPos == y) {
                    b0 = 0;
                }
                if (yPos >= y + 1 + height - 2) {
                    b0 = 2;
                }
                BlockPos.Mutable mutable = new BlockPos.Mutable();
                for (int xPos = x - b0; xPos <= x + b0 && flag; ++xPos) {
                    for (int zPos = z - b0; zPos <= z + b0 && flag; ++zPos) {
                        if (yPos >= 0 && yPos < 256) {
                            if (AbstractTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)mutable.func_181079_c(xPos, yPos, zPos))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            return flag;
        }
        return false;
    }

    private boolean ensureViableBlockUnderneath(BlockPos pos, IWorldGenerationReader worldIn, TreeFeatureConfig config) {
        if (PalmTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177977_b(), (IPlantable)config.getSapling()) || worldIn.func_217375_a(pos.func_177977_b(), state -> state.func_203425_a(BlockTags.field_203436_u))) {
            if (PalmTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177977_b(), (IPlantable)config.getSapling())) {
                this.setDirtAt(worldIn, pos.func_177977_b(), pos);
            }
            return true;
        }
        return false;
    }

    private void placeCocoa(IWorldGenerationReader worldIn, int age, BlockPos pos, Direction side) {
        this.func_202278_a((IWorldWriter)worldIn, pos, (BlockState)((BlockState)((Block)ModBlocks.coconutNut.get()).func_176223_P().func_206870_a((IProperty)CocoaBlock.field_176501_a, (Comparable)Integer.valueOf(age))).func_206870_a((IProperty)CocoaBlock.field_185512_D, (Comparable)side));
    }
}

