/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.blocks;

import com.maideniles.maidensmaterials.init.MaidensChestTypes;
import com.maideniles.maidensmaterials.tileentity.TestChestTileEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseChestBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape IRON_CHEST_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final MaidensChestTypes type;
    private final Supplier<TileEntityType<? extends TestChestTileEntity>> tileEntityTypeSupplier;

    public BaseChestBlock(MaidensChestTypes typeIn, Supplier<TileEntityType<? extends TestChestTileEntity>> tileEntityTypeSupplierIn, AbstractBlock.Properties propertiesIn) {
        super(propertiesIn);
        this.type = typeIn;
        this.tileEntityTypeSupplier = tileEntityTypeSupplierIn;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return IRON_CHEST_SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TestChestTileEntity) {
            ((TestChestTileEntity)tileentity).wasPlaced(placer, stack);
            if (stack.func_82837_s()) {
                ((TestChestTileEntity)tileentity).func_213903_a(stack.func_200301_q());
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TestChestTileEntity) {
                ((TestChestTileEntity)tileentity).removeAdornments();
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TestChestTileEntity)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        INamedContainerProvider inamedcontainerprovider;
        if (!worldIn.field_72995_K && (inamedcontainerprovider = this.func_220052_b(state, worldIn, pos)) != null) {
            player.func_213829_a(inamedcontainerprovider);
            player.func_71029_a(this.getOpenStat());
        }
        return ActionResultType.SUCCESS;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    private static boolean isBlocked(IWorld iWorld, BlockPos blockPos) {
        return BaseChestBlock.isBelowSolidBlock((IBlockReader)iWorld, blockPos) || BaseChestBlock.isCatSittingOn(iWorld, blockPos);
    }

    private static boolean isBelowSolidBlock(IBlockReader iBlockReader, BlockPos worldIn) {
        BlockPos blockpos = worldIn.func_177984_a();
        return iBlockReader.func_180495_p(blockpos).func_215686_e(iBlockReader, blockpos);
    }

    private static boolean isCatSittingOn(IWorld iWorld, BlockPos blockPos) {
        List list = iWorld.func_217357_a(CatEntity.class, new AxisAlignedBB((double)blockPos.func_177958_n(), (double)(blockPos.func_177956_o() + 1), (double)blockPos.func_177952_p(), (double)(blockPos.func_177958_n() + 1), (double)(blockPos.func_177956_o() + 2), (double)(blockPos.func_177952_p() + 1)));
        if (!list.isEmpty()) {
            for (CatEntity catentity : list) {
                if (!catentity.func_70608_bn()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public static MaidensChestTypes getTypeFromItem(Item itemIn) {
        return BaseChestBlock.getTypeFromBlock(Block.func_149634_a((Item)itemIn));
    }

    public static MaidensChestTypes getTypeFromBlock(Block blockIn) {
        return blockIn instanceof BaseChestBlock ? ((BaseChestBlock)blockIn).getType() : null;
    }

    public MaidensChestTypes getType() {
        return this.type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.ICallback<TestChestTileEntity, Float2FloatFunction> getLid(final IChestLid p_226917_0_) {
        return new TileEntityMerger.ICallback<TestChestTileEntity, Float2FloatFunction>(){

            public Float2FloatFunction func_225539_a_(TestChestTileEntity p_225539_1_, TestChestTileEntity p_225539_2_) {
                return p_226921_2_ -> Math.max(p_225539_1_.func_195480_a(p_226921_2_), p_225539_2_.func_195480_a(p_226921_2_));
            }

            public Float2FloatFunction func_225538_a_(TestChestTileEntity p_225538_1_) {
                return p_225538_1_::func_195480_a;
            }

            public Float2FloatFunction func_225537_b_() {
                return arg_0 -> ((IChestLid)p_226917_0_).func_195480_a(arg_0);
            }
        };
    }

    public TileEntityMerger.ICallbackWrapper<? extends TestChestTileEntity> getWrapper(BlockState blockState, World world, BlockPos blockPos, boolean p_225536_4_) {
        BiPredicate<IWorld, BlockPos> biPredicate = p_225536_4_ ? (p_226918_0_, p_226918_1_) -> false : BaseChestBlock::isBlocked;
        return TileEntityMerger.func_226924_a_(this.tileEntityTypeSupplier.get(), BaseChestBlock::getMergerType, BaseChestBlock::getDirectionToAttached, (DirectionProperty)FACING, (BlockState)blockState, (IWorld)world, (BlockPos)blockPos, biPredicate);
    }

    public static TileEntityMerger.Type getMergerType(BlockState blockState) {
        return TileEntityMerger.Type.SINGLE;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return direction.func_176735_f();
    }
}

