/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.util;

import com.maideniles.maidensmaterials.util.KVP;
import com.maideniles.maidensmaterials.world.gen.ore.OreType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigHandler {
    public static KVP getConfig() {
        String contents = "";
        try {
            contents = new String(Files.readAllBytes(ConfigHandler.getConfigPath()));
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return KVP.parse(contents);
    }

    public static Path getConfigPath() {
        return FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("maidensmaterials.kvp");
    }

    private static String multilineString(String ... args) {
        return String.join((CharSequence)"\n", args);
    }

    private static String makeConfigEntry(String key, Object value) {
        return KVP.escape(key) + ": " + KVP.escape(value.toString());
    }

    public static boolean makeConfigIfAbsent() {
        try {
            File config = ConfigHandler.getConfigPath().toFile();
            if (!config.exists()) {
                config.createNewFile();
                try (FileWriter fileWriter = new FileWriter(config.getAbsoluteFile());){
                    fileWriter.write(ConfigHandler.getDefaultConfigContents());
                }
            }
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static String getDefaultConfigContents() {
        return ConfigHandler.multilineString("!Maiden's Marvelous Materials Config", "!Biome Weights", ConfigHandler.makeConfigEntry("Ornamental Forest Biome Weight", 100), ConfigHandler.makeConfigEntry("Ornamental Orchard Biome Weight", 100), ConfigHandler.makeConfigEntry("Oasis Shores Biome Weight", 100), ConfigHandler.makeOreConfig());
    }

    public static String makeOreConfig() {
        String result = "";
        for (OreType ore : OreType.values()) {
            result = result + ConfigHandler.multilineString("", "!" + ore.getName() + " Generation Options", ConfigHandler.makeConfigEntry(ore.getName() + " max vein size", ore.getMaxVeinSize()), ConfigHandler.makeConfigEntry(ore.getName() + " min height", ore.getMinHeight()), ConfigHandler.makeConfigEntry(ore.getName() + " max height", ore.getMaxHeight()), "");
        }
        return result;
    }

    public static class ConfigKeys {
        public static final String ORNAMENTAL_FOREST_WEIGHT = "Ornamental Forest Biome Weight";
        public static final String ORNAMENTAL_ORCHARD_WEIGHT = "Ornamental Orchard Biome Weight";
        public static final String OASIS_SHORES_WEIGHT = "Oasis Shores Biome Weight";
    }
}

