/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.util.Pair;

public class KVP {
    private static final Logger LOGGER = Logger.getLogger("KVP");
    private LinkedHashMap<String, String> pairs = new LinkedHashMap();

    private void internalAdd(String key, String value) {
        this.pairs.put(key, value);
    }

    private String internalGet(String key) {
        return this.pairs.get(key);
    }

    private <T> T internalGetHelper(Function<String, T> transformer, BiFunction<T, String, Boolean> validator, String key, T fallback) {
        T transformed;
        String value;
        if (this.hasKey(key) && (value = this.internalGet(key)) != null && validator.apply(transformed = transformer.apply(value), value).booleanValue()) {
            return transformed;
        }
        return fallback;
    }

    private static String internalSmartReplaceAll(String text, String pattern, Function<MatchResult, String> replacer) {
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacer.apply(matcher.toMatchResult()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public KVP(String source) {
        ArrayList unexpectedTokens = new ArrayList();
        String[] lines = source.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int l = i;
            String line = lines[i].replaceAll("^$\n", "").replaceAll("(?<!\\$)!.*$", "");
            line = KVP.internalSmartReplaceAll(line, "^\\s*?(.*?)(?<!\\$):\\s*?(?<!\\$)(['\"])(.*?)(?<!\\$)\\2\\s*$", matches -> {
                this.internalAdd(KVP.unescape(matches.group(1)), KVP.unescape(matches.group(3)));
                return "";
            });
            line = KVP.internalSmartReplaceAll(line, "^\\s*?(.*?)(?<!\\$):(.*?)$", matches -> {
                this.internalAdd(KVP.unescape(matches.group(1)), KVP.unescape(matches.group(2).trim()));
                return "";
            });
            line = line.replaceAll("^$\n", "");
            line = KVP.internalSmartReplaceAll(line, "(.+)", matches -> {
                unexpectedTokens.add(new Pair((Object)matches.group(1), (Object)l));
                return "";
            });
        }
        for (Pair pair : unexpectedTokens) {
            LOGGER.log(Level.WARNING, String.format("Unexpected token \"%s\" in Key Value Pair on line %s", pair.getKey(), pair.getValue()));
        }
    }

    public static KVP parse(String source) {
        return new KVP(source);
    }

    public static String unescape(String string) {
        return string.replaceAll("\\$endline", "\n").replaceAll("\\$([$!:'\"])", "$1");
    }

    public static String escape(String string) {
        return string.replaceAll("([$!:'\"])", "\\$$1").replaceAll("\n", "$endline");
    }

    public String getString(String key) {
        return this.getString(key, "");
    }

    public String getString(String key, String fallback) {
        return this.internalGetHelper(v -> v, (t, v) -> true, key, fallback);
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, Boolean.FALSE);
    }

    public Boolean getBoolean(String key, Boolean fallback) {
        return this.internalGetHelper(v -> v.trim().equalsIgnoreCase("true"), (t, v) -> v.trim().equalsIgnoreCase("true") || v.trim().equalsIgnoreCase("false"), key, fallback);
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, new Integer(0));
    }

    public Integer getInteger(String key, Integer fallback) {
        return this.internalGetHelper(v -> {
            try {
                return Integer.valueOf(v.trim());
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }, (t, v) -> t != null, key, fallback);
    }

    public Float getDecimal(String key) {
        return this.getDecimal(key, new Float(0.0f));
    }

    public Float getDecimal(String key, Float fallback) {
        return this.internalGetHelper(v -> {
            try {
                return Float.valueOf(v.trim());
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }, (t, v) -> t != null, key, fallback);
    }

    public Date getDate(String key) {
        return this.getDate(key, new Date("January 1, 1970"));
    }

    public Date getDate(String key, Date fallback) {
        return this.internalGetHelper(v -> {
            try {
                return new Date(v.trim());
            }
            catch (IllegalArgumentException exception) {
                return null;
            }
        }, (t, v) -> t != null, key, fallback);
    }

    public boolean hasKey(String key) {
        return this.pairs.containsKey(key);
    }

    public String[] keys() {
        return (String[])this.pairs.keySet().toArray();
    }

    public String[] values() {
        return (String[])this.pairs.values().toArray();
    }
}

