/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.gen;

import com.maideniles.maidensmaterials.MaidensMaterials;
import com.maideniles.maidensmaterials.init.ModBiomes;
import com.maideniles.maidensmaterials.init.ModBlocks;
import com.maideniles.maidensmaterials.world.biome.ModConfiguredSurfaceBuilders;
import com.maideniles.maidensmaterials.world.biome.ModSurfaceBuilders;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="maidensmaterials", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBiomeGeneration {
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void register(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        ModBiomeGeneration.registerBiome(ModConfiguredSurfaceBuilders.ORNAMENTAL_FOREST_SURFACE.func_240901_a_(), ((Block)ModBlocks.ORNAMENTAL_GRASS.get()).func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P());
        ModBiomeGeneration.registerBiome(ModConfiguredSurfaceBuilders.OASIS_SHORE_SURFACE.func_240901_a_(), ((Block)ModBlocks.SPARKLING_SAND.get()).func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P());
        ModBiomeGeneration.registerBiome(ModConfiguredSurfaceBuilders.ORNAMENTAL_ORCHARD_SURFACE.func_240901_a_(), Blocks.field_196658_i.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P());
    }

    @SubscribeEvent
    public static void setupBiome(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBiomeGeneration.addBiome((Biome)ModBiomes.ORNAMENTAL_FOREST_BIOME.get(), BiomeManager.BiomeType.WARM, MaidensMaterials.getInstance().config.getInteger("Ornamental Forest Biome Weight", 100), BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.FOREST);
            ModBiomeGeneration.addBiome((Biome)ModBiomes.OASIS_SHORE_BIOME.get(), BiomeManager.BiomeType.WARM, MaidensMaterials.getInstance().config.getInteger("Oasis Shores Biome Weight", 100), BiomeDictionary.Type.BEACH, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT);
            ModBiomeGeneration.addBiome((Biome)ModBiomes.ORNAMENTAL_ORCHARD_BIOME.get(), BiomeManager.BiomeType.WARM, MaidensMaterials.getInstance().config.getInteger("Ornamental Orchard Biome Weight", 100), BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.RIVER);
        });
    }

    private static void registerBiome(ResourceLocation biomeRL, BlockState topBlock, BlockState fillerBlock, BlockState underwaterBlock) {
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)biomeRL, (Object)((SurfaceBuilder)ModSurfaceBuilders.LOGGING_DEFAULT.get()).func_242929_a((ISurfaceBuilderConfig)new SurfaceBuilderConfig(topBlock, fillerBlock, underwaterBlock)));
    }

    private static void addBiome(Biome biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... types) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)));
        BiomeDictionary.addTypes((RegistryKey)key, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, weight));
    }
}

