/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.gen.ore;

import com.google.common.collect.Lists;
import com.maideniles.maidensmaterials.world.gen.ore.OreType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="maidensmaterials", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModOreGeneration {
    @SubscribeEvent
    public static void generateOres(FMLLoadCompleteEvent event) {
        for (OreType ore : OreType.values()) {
            OreFeatureConfig oreFeature = new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ore.getBlock().func_176223_P(), ore.getMaxVeinSize());
            ConfiguredPlacement configuredPlacement = Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(ore.getMinHeight(), ore.getMaxHeight()));
            Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)ore.getBlock().getRegistryName(), (Object)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)oreFeature).func_227228_a_(configuredPlacement).func_242728_a()).func_242731_b(ore.getMaxVeinSize()));
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (biome.func_201856_r().equals((Object)Biome.Category.NETHER) || biome.func_201856_r().equals((Object)Biome.Category.THEEND)) continue;
                ModOreGeneration.addFeatureToBiome(biome, GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)WorldGenRegistries.field_243653_e.func_82594_a(ore.getBlock().getRegistryName()));
            }
        }
    }

    public static void addFeatureToBiome(Biome biome, GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> configuredFeature) {
        ArrayList biomeFeatures = new ArrayList(biome.func_242440_e().func_242498_c());
        while (biomeFeatures.size() <= decoration.ordinal()) {
            biomeFeatures.add(Lists.newArrayList());
        }
        ArrayList<Supplier<ConfiguredFeature>> features = new ArrayList<Supplier<ConfiguredFeature>>((Collection)biomeFeatures.get(decoration.ordinal()));
        features.add(() -> configuredFeature);
        biomeFeatures.set(decoration.ordinal(), features);
        ObfuscationReflectionHelper.setPrivateValue(BiomeGenerationSettings.class, (Object)biome.func_242440_e(), biomeFeatures, (String)"field_242484_f");
    }
}

