/*
 * Decompiled with CFR 0.152.
 */
package com.maideniles.maidensmaterials.world.gen.ore;

import com.maideniles.maidensmaterials.init.ModBlocks;
import com.maideniles.maidensmaterials.util.KVP;
import net.minecraft.block.Block;
import net.minecraftforge.fml.RegistryObject;

public enum OreType {
    CITRINE("Citrine", ModBlocks.CITRINE_ORE, 8, 41, 60),
    JADE("Jade", ModBlocks.JADE_ORE, 8, 41, 60),
    JASPER("Jasper", ModBlocks.JASPER_ORE, 8, 41, 60),
    MOONSTONE("Moonstone", ModBlocks.MOONSTONE_ORE, 8, 41, 60),
    AVENTURINE("Aventurine", ModBlocks.AVENTURINE_ORE, 6, 21, 40),
    LABRADORITE("Labradorite", ModBlocks.LABRADORITE_ORE, 6, 21, 40),
    MICA("Mica", ModBlocks.MICA_ORE, 6, 21, 40),
    ROSE_QUARTZ("Rose Quartz", ModBlocks.ROSE_QUARTZ_ORE, 6, 21, 40),
    AMETHYST("Amethyst", ModBlocks.AMETHYST_ORE, 4, 0, 20),
    CARNELIAN("Carnelian", ModBlocks.CARNELIAN_ORE, 4, 0, 20),
    CHALCOPYRITE("Chalcopyrite", ModBlocks.CHALCOPYRITE_ORE, 4, 0, 20),
    SODALITE("Sodalite", ModBlocks.SODALITE_ORE, 4, 0, 20);

    private final String name;
    private final RegistryObject<Block> block;
    private int maxVeinSize;
    private int minHeight;
    private int maxHeight;

    private OreType(String name, RegistryObject<Block> Block2, int maxVeinSize, int minHeight, int maxHeight) {
        this.name = name;
        this.block = Block2;
        this.maxVeinSize = maxVeinSize;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public Block getBlock() {
        return (Block)this.block.get();
    }

    public int getMaxVeinSize() {
        return this.maxVeinSize;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public String getName() {
        return this.name;
    }

    public static OreType get(Block block) {
        for (OreType ore : OreType.values()) {
            if (block != ore.block.get()) continue;
            return ore;
        }
        return null;
    }

    public static void loadFromConfig(KVP config) {
        for (OreType ore : OreType.values()) {
            ore.maxVeinSize = config.getInteger(ore.name + " max vein size", ore.maxVeinSize);
            ore.minHeight = config.getInteger(ore.name + " min height", ore.minHeight);
            ore.maxHeight = config.getInteger(ore.name + " max height", ore.maxHeight);
        }
    }
}

