/*
 * Decompiled with CFR 0.152.
 */
package com.majruszs_difficulty.blocks;

import com.majruszs_difficulty.Instances;
import com.majruszs_difficulty.MajruszsDifficulty;
import com.majruszs_difficulty.MajruszsHelper;
import com.mlib.MajruszLibrary;
import com.mlib.config.AvailabilityConfig;
import com.mlib.config.ConfigGroup;
import com.mlib.config.DoubleConfig;
import com.mlib.config.IConfig;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EndShardOre
extends Block {
    private static final String WARNING_TRANSLATION_KEY = "block.majruszs_difficulty.end_shard_ore.warning";
    protected final ConfigGroup configGroup;
    protected final AvailabilityConfig availability;
    protected final DoubleConfig triggerDistance;

    public EndShardOre() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151673_t).harvestLevel(4).func_235861_h_().func_200948_a(30.0f, 1200.0f).func_200947_a(SoundType.field_235595_Q_));
        String availabilityComment = "Should this ore be available in survival mode? (ore generation, loot tables etc.) (requires game restart!)";
        String triggerComment = "Maximum distance within which all nearby Endermans will be triggered. (when block was mined)";
        this.availability = new AvailabilityConfig("is_enabled", availabilityComment, true, true);
        this.triggerDistance = new DoubleConfig("trigger_distance", triggerComment, false, 700.0, 0.0, 1000000.0);
        this.configGroup = (ConfigGroup)MajruszsDifficulty.FEATURES_GROUP.addGroup((IConfig)new ConfigGroup("EndShardOre", "Configuration for new late game ore."));
        this.configGroup.addConfigs(new IConfig[]{this.availability, this.triggerDistance});
    }

    public int getExpDrop(BlockState state, IWorldReader world, BlockPos position, int fortuneLevel, int silkTouchLevel) {
        return silkTouchLevel == 0 ? MathHelper.func_76136_a((Random)MajruszLibrary.RANDOM, (int)6, (int)11) : 0;
    }

    @SubscribeEvent
    public static void onBlockDestroying(PlayerEvent.BreakSpeed event) {
        BlockState blockState = event.getState();
        if (!(blockState.func_177230_c() instanceof EndShardOre)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        player.func_146105_b((ITextComponent)new TranslationTextComponent(WARNING_TRANSLATION_KEY).func_240699_a_(TextFormatting.BOLD), true);
    }

    @SubscribeEvent
    public static void onBlockDestroy(BlockEvent.BreakEvent event) {
        BlockState blockState = event.getState();
        if (blockState.func_177230_c() instanceof EndShardOre) {
            EndShardOre.targetEndermansOnEntity((LivingEntity)event.getPlayer(), Instances.END_SHARD_ORE.triggerDistance.get());
        }
    }

    public static void targetEndermansOnEntity(LivingEntity target, double maximumDistance) {
        if (!(target.field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)target.field_70170_p;
        for (Entity entity : world.func_217482_a(null, enderman -> enderman.func_70068_e((Entity)target) < maximumDistance)) {
            EndermanEntity enderman2;
            LivingEntity currentEndermanTarget;
            if (!(entity instanceof EndermanEntity) || (currentEndermanTarget = (enderman2 = (EndermanEntity)entity).func_70643_av()) != null && currentEndermanTarget.func_70089_S()) continue;
            enderman2.func_70604_c(target);
        }
    }

    public boolean isEnabled() {
        return this.availability.isEnabled();
    }

    public static class EndShardOreItem
    extends BlockItem {
        public EndShardOreItem() {
            super((Block)Instances.END_SHARD_ORE, new Item.Properties().func_200917_a(64).func_200916_a(Instances.ITEM_GROUP));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            MajruszsHelper.addExtraTooltipIfDisabled(tooltip, Instances.END_SHARD_ORE.isEnabled());
        }
    }
}

